% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoint_services}
\alias{ec2_describe_vpc_endpoint_services}
\title{Describes available services to which you can create a VPC endpoint}
\usage{
ec2_describe_vpc_endpoint_services(DryRun, ServiceNames, Filters,
  MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ServiceNames}{One or more service names.}

\item{Filters}{One or more filters.
\itemize{
\item \code{service-name}: The name of the service.
}}

\item{MaxResults}{The maximum number of items to return for this request. The request
returns a token that you can specify in a subsequent call to get the
next set of results.

Constraint: If the value is greater than 1000, we return only 1000
items.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a prior call.)}
}
\description{
Describes available services to which you can create a VPC endpoint.
}
\section{Request syntax}{
\preformatted{svc$describe_vpc_endpoint_services(
  DryRun = TRUE|FALSE,
  ServiceNames = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
