% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_regions}
\alias{ec2_describe_regions}
\title{Describes one or more regions that are currently available to you}
\usage{
ec2_describe_regions(Filters, RegionNames, DryRun)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{endpoint} - The endpoint of the region (for example,
\code{ec2.us-east-1.amazonaws.com}).
\item \code{region-name} - The name of the region (for example, \code{us-east-1}).
}}

\item{RegionNames}{The names of one or more regions.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more regions that are currently available to you.
}
\details{
For a list of the regions supported by Amazon EC2, see \href{https://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region}{Regions and Endpoints}.
}
\section{Request syntax}{
\preformatted{svc$describe_regions(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  RegionNames = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example describes all the regions that are available to you.
\donttest{svc$describe_regions()}

}
\keyword{internal}
