% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_query_schema_version_metadata}
\alias{glue_query_schema_version_metadata}
\title{Queries for the schema version metadata information}
\usage{
glue_query_schema_version_metadata(SchemaId, SchemaVersionNumber,
  SchemaVersionId, MetadataList, MaxResults, NextToken)
}
\arguments{
\item{SchemaId}{A wrapper structure that may contain the schema name and Amazon Resource
Name (ARN).}

\item{SchemaVersionNumber}{The version number of the schema.}

\item{SchemaVersionId}{The unique version ID of the schema version.}

\item{MetadataList}{Search key-value pairs for metadata, if they are not provided all the
metadata information will be fetched.}

\item{MaxResults}{Maximum number of results required per page. If the value is not
supplied, this will be defaulted to 25 per page.}

\item{NextToken}{A continuation token, if this is a continuation call.}
}
\description{
Queries for the schema version metadata information.
}
\section{Request syntax}{
\preformatted{svc$query_schema_version_metadata(
  SchemaId = list(
    SchemaArn = "string",
    SchemaName = "string",
    RegistryName = "string"
  ),
  SchemaVersionNumber = list(
    LatestVersion = TRUE|FALSE,
    VersionNumber = 123
  ),
  SchemaVersionId = "string",
  MetadataList = list(
    list(
      MetadataKey = "string",
      MetadataValue = "string"
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
