% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_add_instance_fleet}
\alias{emr_add_instance_fleet}
\title{Adds an instance fleet to a running cluster}
\usage{
emr_add_instance_fleet(ClusterId, InstanceFleet)
}
\arguments{
\item{ClusterId}{[required] The unique identifier of the cluster.}

\item{InstanceFleet}{[required] Specifies the configuration of the instance fleet.}
}
\description{
Adds an instance fleet to a running cluster.

The instance fleet configuration is available only in Amazon EMR
versions 4.8.0 and later, excluding 5.0.x.
}
\section{Request syntax}{
\preformatted{svc$add_instance_fleet(
  ClusterId = "string",
  InstanceFleet = list(
    Name = "string",
    InstanceFleetType = "MASTER"|"CORE"|"TASK",
    TargetOnDemandCapacity = 123,
    TargetSpotCapacity = 123,
    InstanceTypeConfigs = list(
      list(
        InstanceType = "string",
        WeightedCapacity = 123,
        BidPrice = "string",
        BidPriceAsPercentageOfOnDemandPrice = 123.0,
        EbsConfiguration = list(
          EbsBlockDeviceConfigs = list(
            list(
              VolumeSpecification = list(
                VolumeType = "string",
                Iops = 123,
                SizeInGB = 123
              ),
              VolumesPerInstance = 123
            )
          ),
          EbsOptimized = TRUE|FALSE
        ),
        Configurations = list(
          list(
            Classification = "string",
            Configurations = list(),
            Properties = list(
              "string"
            )
          )
        )
      )
    ),
    LaunchSpecifications = list(
      SpotSpecification = list(
        TimeoutDurationMinutes = 123,
        TimeoutAction = "SWITCH_TO_ON_DEMAND"|"TERMINATE_CLUSTER",
        BlockDurationMinutes = 123,
        AllocationStrategy = "capacity-optimized"
      ),
      OnDemandSpecification = list(
        AllocationStrategy = "lowest-price"
      )
    )
  )
)
}
}

\keyword{internal}
