% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagerings2.R
\name{imagerings2}
\alias{imagerings2}
\title{Plot a ring chart using images to fill the rings.}
\usage{
imagerings2(group1, group2, pct1, pct2, label1, label2, label.size1 = 4,
  label.size2 = 4, label.color1 = "black", label.color2 = "black",
  label.distance1 = 1.2, label.distance2 = 1.2, pattern.type1,
  pattern.type2, pattern.type.inner, frame.color = "black",
  frame.size = 1, r1, r2, r3)
}
\arguments{
\item{group1}{a vector of strings, containing the names of each slice for the inner ring.}

\item{group2}{a vector of strings, containing the names of each slice for the outer ring.}

\item{pct1}{a vector of non-negative numbers, containing percentages of each group for the inner ring.
The numbers must sum up to 100.}

\item{pct2}{a vector of non-negative numbers, containing percentages of each group for the outer ring.
The numbers must sum up to 100.}

\item{label1}{a vector of strings, giving the names for the slices shown in the ring chart for the inner ring.}

\item{label2}{a vector of strings, giving the names for the slices shown in the ring chart for the outer ring.}

\item{label.size1}{the font size of labels shown in the ring chart for the inner ring.}

\item{label.size2}{the font size of labels shown in the ring chart for the outer ring.}

\item{label.color1}{the color of labels shown in the ring chart for the inner ring.}

\item{label.color2}{the color of labels shown in the ring chart for the outer ring.}

\item{label.distance1}{the distance of labels from the border of the ring chart for the inner ring.}

\item{label.distance2}{the distance of labels from the border of the ring chart for the outer ring.}

\item{pattern.type1}{a list of objects returned by \code{readPNG} and \code{readJPEG} used to fill the inner ring.}

\item{pattern.type2}{a list of objects returned by \code{readPNG} and \code{readJPEG} used to fill the outer ring.}

\item{pattern.type.inner}{an object returned by \code{readPNG} and \code{readJPEG} used to fill the inner circle.}

\item{frame.color}{the color for the borders of rings.}

\item{frame.size}{a numeric value, the line size for the borders of rings.}

\item{r1}{a numeric value, the inner radius of the inner ring.}

\item{r2}{a numeric value, the outer radius of the inner ring.}

\item{r3}{a numeric value, the outer radius of the outer ring.}
}
\value{
A ggplot object.
}
\description{
The \code{imagerings2} function is a tool for creating versatile ring charts 
by filling the rings with images.
}
\details{
\code{imagerings2} function offers flexible ways of doing ring charts.
}
\examples{
#Example 1
library(patternplot)
library(png)
library(ggplot2)
group1<-c("Wind", "Hydro", "Solar", "Coal", "Natural Gas", "Oil")
pct1<-c(12, 15, 8, 22, 18, 25)
label1<-paste(group1, " \\n ", pct1 , "\%", sep="")
location<-gsub('\\\\','/',tempdir(), fixed=TRUE)
pattern(type="blank", density=1, color='white', pattern.line.size=1, 
background.color="darkolivegreen1",  pixel=20, res=15)
Wind<-readPNG(paste(location,'/',"blank",".png", sep=''))
pattern(type="blank", density=1, color='white', pattern.line.size=1, 
background.color="white", pixel=20, res=15)
Hydro<-readPNG(paste(location,'/',"blank",".png", sep=''))
pattern(type="blank", density=1, color='white', pattern.line.size=1, 
background.color="indianred",  pixel=20, res=15)
Solar<-readPNG(paste(location,'/',"blank",".png", sep=''))
pattern(type="blank", density=1, color='white', pattern.line.size=1, 
background.color="gray81",  pixel=20, res=15)
Coal<-readPNG(paste(location,'/',"blank",".png", sep=''))
pattern(type="blank", density=1, color='white', pattern.line.size=1, 
background.color="white",  pixel=20, res=15)
NaturalGas<-readPNG(paste(location,'/',"blank",".png", sep=''))
pattern(type="blank", density=1, color='white', pattern.line.size=1, 
background.color="sandybrown",  pixel=20, res=15)
Oil<-readPNG(paste(location,'/',"blank",".png", sep=''))
pattern.type1<-list(Wind, Hydro, Solar, Coal, NaturalGas, Oil)

group2<-c("Renewable", "Non-Renewable")
pct2<-c(35, 65)
label2<-paste(group2, " \\n ", pct2 , "\%", sep="")
pattern(type="grid", density=12, color='white', pattern.line.size=5, 
background.color="seagreen", pixel=20, res=15)
Renewable<-readPNG(paste(location,'/',"grid",".png", sep=''))
pattern(type="blank", density=1, color='white', pattern.line.size=1, 
background.color="deepskyblue",  pixel=20, res=15)
NonRenewable<-readPNG(paste(location,'/',"blank",".png", sep=''))


pattern.type2<-list(Renewable, NonRenewable)
pattern.type.inner<-readPNG(system.file("img", "earth.png", package="patternplot"))

g<-imagerings2(group1, group2,pct1,pct2, label1, label2, label.size1=3, label.size2=3.5, 
label.color1='black', label.color2='black', label.distance1=0.7, label.distance2=1.3, 
pattern.type1, pattern.type2, pattern.type.inner, frame.color='skyblue',frame.size=1, 
r1=2.2, r2=4.2, r3=5)
g<-g+scale_x_continuous(limits=c(-7, 7))+scale_y_continuous(limits=c(-7, 7))
suppressWarnings(print(g))








}
\seealso{
Function \code{patternrings2}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
