% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagepie.R
\name{imagepie}
\alias{imagepie}
\title{Plot a pie chart with slices filled with png and jpeg images.}
\usage{
imagepie(group, pct, label, label.size = 4, label.color = "black",
  label.distance = 1.35, pattern.type, frame.color = "black",
  frame.size = 1)
}
\arguments{
\item{group}{a vector of strings, containing the names of each slice.}

\item{pct}{a vector of non-negative numbers, containing percentages of each group.
The numbers must sum up to 100.}

\item{label}{a vector of strings, giving the names for the slices shown in the pie chart.}

\item{label.size}{the font size of labels shown in the pie chart.}

\item{label.color}{the color of labels shown in the pie chart.}

\item{label.distance}{the distance of labels from the border of the pie chart.}

\item{pattern.type}{a list of objects returned by \code{readPNG} and \code{readJPEG} used to fill slices.}

\item{frame.color}{the color for the borders of slices.}

\item{frame.size}{a numeric value, the line size for the borders of slices.}
}
\value{
A ggplot object.
}
\description{
The \code{imagepie} function is a tool for creating versatile pie charts 
by filling the slices with external png and jpeg images. It can create 
either black and white pie charts which are useful for scientific publications, 
or colorful pie charts which are good for presentations.
}
\details{
\code{imagepie} function offers flexible ways in doing pie charts.
}
\examples{
library(patternplot)

#Fill slices with png images.
library(png)
Lines <-  readPNG(system.file("img", "lines.png", package="patternplot"))
Chessboard <-  readPNG(system.file("img", "chessboard.png", package="patternplot"))
Dots <-  readPNG(system.file("img", "dots.png", package="patternplot"))

pattern.type<-list(Chessboard, Lines,Dots)
group<-c('chessboard','Lines',  'Dots')
pct<-c(25, 40,  35)
label<-c("Chessboard 25\\\% ", "Lines 40\\\%",  "Dots 35\\\%")

p<-imagepie(group=group,pct=pct,label=label,pattern.type=pattern.type,label.distance=1.26, 
              frame.color='black')
p

#Fill slices with jpeg images.
library(jpeg)
Tomatoes <-  readJPEG(system.file("img", "tomatoes.jpg", package="patternplot"))
Peas <- readJPEG(system.file("img", "peas.jpg", package="patternplot"))
Peppers <-  readJPEG(system.file("img", "peppers.jpg", package="patternplot"))

pattern.type<-list(Tomatoes,Peas,Peppers)
group<-c('Tomatoes', 'Peas', 'Peppers')
pct<-c(40, 25, 35)
label<-c("Tomatoes \\n 40\\\%", "Peas \\n 25\\\% ", "Peppers \\n 35\\\%")

p<-imagepie(group=group,pct=pct,label=label,pattern.type=pattern.type,label.distance=1.25, 
              frame.color='burlywood4', frame.size=0.8, label.size=6, label.color='forestgreen')
p

}
\author{
Chunqiao Luo (cluo@uams.edu)
}
\seealso{
Function \code{patternpie}
}

