% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{color_kegg_pathway}
\alias{color_kegg_pathway}
\title{Color hsa KEGG pathway}
\usage{
color_kegg_pathway(
  pw_id,
  change_vec,
  scale_vals = TRUE,
  node_cols = NULL,
  legend.position = "top"
)
}
\arguments{
\item{pw_id}{hsa KEGG pathway id (e.g. hsa05012)}

\item{change_vec}{vector of change values, names should be hsa KEGG gene ids}

\item{scale_vals}{should change values be scaled? (default = \code{TRUE})}

\item{node_cols}{low, middle and high color values for coloring the pathway nodes
(default = \code{NULL}). If \code{node_cols=NULL}, the low, middle and high color
are set as 'green', 'gray' and 'red'. If all change values are 1e6 (in case no
changes are supplied, this dummy value is assigned by
\code{\link{input_processing}}), only one color ('#F38F18' if NULL) is used.}

\item{legend.position}{the default position of legends ("none", "left",
"right", "bottom", "top", "inside")}
}
\value{
a ggplot object containing the colored KEGG pathway diagram visualization
}
\description{
Color hsa KEGG pathway
}
\examples{
\dontrun{
pw_id <- 'hsa00010'
change_vec <- c(-2, 4, 6)
names(change_vec) <- c('hsa:2821', 'hsa:226', 'hsa:229')
result <- pathfindR:::color_kegg_pathway(pw_id, change_vec)
}
}
