% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.volcano}
\alias{pal.volcano}
\title{Show a colormap with a surface of volcano elevation}
\usage{
pal.volcano(pal, n = 100, main = "")
}
\arguments{
\item{pal}{A palette function or a vector of colors.}

\item{n}{The number of colors to display for palette functions.}

\item{main}{Main title}
}
\value{
None.
}
\description{
Some palettes with dark colors at one end of the palette hide the 
shape of the volcano in the dark colors. Viridis is bad.
}
\details{
What to look for:

1. Can you locate the highest point on the volcano?

2. Are the upper-right and lower-right corners the same elevation?

3. Do any Mach bands circle the peak?
}
\examples{
pal.volcano(parula)
pal.volcano(brewer.rdbu) # Mach banding is bad
pal.volcano(warmcool, main="warmcool") # No Mach band 
pal.volcano(rev(viridis(100))) # Bad: peak position is hidden

}
