% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirror.R
\name{mirrorfill}
\alias{mirrorfill}
\title{Fill missing symmetrical landmarks for all specimens in an array using mirrored values from other side of a bilaterally symmetrical object where present}
\usage{
mirrorfill(A, l1, l2)
}
\arguments{
\item{A}{An N x 3 x M matrix where N is the number of landmarks, 3 is the number of dimensions, and M is the number of specimens.}

\item{l1}{Vector of indices for which landmarks to use to make a specimen midline}

\item{l2}{Vector or matrix of pairs of symmetrical landmarks}
}
\description{
Given an N x 3 x M matrix, where N is the number of landmarks, 3 is the number of dimensions, and M is the number of specimens, fill in missing landmarks using their mirrored counterpart.
}
\details{
\code{l2} should be either 
 \itemize{
   \item An even length vector containing pairs of landmarks on either side of the specimen. 
     i.e. l2[1] and l2[2] are paired, l2[3] and l2[4] are paired etc.
   \item A two column matrix with each row giving a pair of symmetrical landmarks.
 }

\code{l2} should be an even number length containing pairs of landmarks
 on either side of the specimen.
}
\examples{
 # Create array
 A <- array(rep(1:36, by = 4), dim = c(12, 3, 4))

 # Make it symmetrical
 A[7:12, 1:2, ] <- A[1:6, 1:2, ]
 A[7:12, 3, ] <- -A[1:6, 3, ]

 # Remove some data points
 missinga <- A
 missinga[1:2, , 1:3] <- NA

 mirrorA <- mirrorfill(missinga, l1 = c(3:6, 9:12), l2 = c(1, 7, 2, 8))

}

