% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packagefinder.r
\name{exploreFields}
\alias{exploreFields}
\title{Searching for packages on CRAN}
\usage{
exploreFields(term, fields = c("Name", "Description", "LongDescription"),
  mode = "or", match = "like", display = "viewer", index = NULL)
}
\arguments{
\item{term}{Search term to look for; character vector must have one element.}

\item{fields}{The list of fields to be scanned for the search term; must be a character vector with one or more field names. Allowed field names are: \code{"Name"}, \code{"Description"}, \code{"LongDescription"}, \code{"Maintainer"}, \code{"Authors@R"}, \code{"Author"}, \code{"License"}, \code{"Imports"}, \code{"Enhances"}, \code{"Depends"}, \code{"Suggests"}, \code{"Reverse depends"}, \code{"Reverse suggests"}, \code{"Reverse enhances"}, \code{"Copyright"}, \code{"Contact"}, \code{"Note"}, \code{"MailingList"}.}

\item{mode}{Indicates whether matches in the field shall be combined with a logical OR or with a logical AND; accordingly, permitted values are \code{"or"} (default) and \code{"and"}. In \code{"or"} mode, every package that has the search term in any of the fields from \code{fields} generates a hit, in \code{"and"} mode the search term must be found in all fields provided to make that package a search hit.}

\item{match}{Either \code{"like"} (default) or \code{"exact"}. Determines if the field content must match the search term exactly or only needs to contain it.}

\item{display}{Describes where the search results shall be shown. Either \code{"viewer"} or \code{"console"}. If \code{"viewer"}, the results are shown in RStudio's Viewer pane if the RStudio IDE is being used). If \code{results = "console"} the search results are shown as a text table in the R console.}

\item{index}{Either a path (or URL) to a search index, or a search index that is already loaded. If no index is provided, \code{exploreFields()} creates an ad hoc search index.}
}
\value{
No return value.
}
\description{
Searches for packages on CRAN by scanning a specified set of information fields for a user-provided search term.
}
\details{
Found packages are listed in alphabetical order, there is no prioritization of search hits as in \code{\link{findPackage}()}.
}
\examples{
\donttest{ exploreFields("Hadley", c("Maintainer", "Authors@R", "Author")) }
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
