% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_help_functions.R
\name{plot_histogram_onetimepoint_twogroups}
\alias{plot_histogram_onetimepoint_twogroups}
\title{Function to plot mean and SE for longitudinal observations for twogroups compared}
\usage{
plot_histogram_onetimepoint_twogroups(
  thedata,
  colname,
  timepointstring,
  xstring,
  ylimits = NULL,
  nbins = NULL
)
}
\arguments{
\item{thedata}{the data where the observations are held}

\item{colname}{columnname in the data where the intersted observations}

\item{timepointstring}{the text that correspond to timepoints
at which the descriptive analysis is done}

\item{xstring}{xlable text}

\item{ylimits}{on hsitogram plot}

\item{nbins}{nbins the number of bins to plot histogram}
}
\value{
the historgram plot at a timepoint for two groups
}
\description{
Function to plot mean and SE for longitudinal observations for twogroups compared
}
\examples{
eg_data <- as.data.frame(list(no = c(1, 2, 3, 4),
mark_at_1 = c(12, 7, 23, 45), gender = c("M", "F", "M", "F"),
mark_at_2 = c(12, 34, 89, 45), trialarm = c("1","1","2","2")))
plot_histogram_onetimepoint_twogroups(eg_data,  c("mark_at_2"), c("1","2"),
 "mark")
}
