% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/3c_costing_opioid_tablets_averageMED_functions.R
\name{costing_opioid_tablets_averageMED_long}
\alias{costing_opioid_tablets_averageMED_long}
\title{Function to estimate the cost of tablets when IPD is in long format}
\usage{
costing_opioid_tablets_averageMED_long(
  the_columns,
  ind_part_data_long,
  name_med,
  brand_med = NULL,
  dose_med,
  unit_med = NULL,
  no_taken,
  freq_taken,
  timeperiod,
  unit_cost_data,
  unit_cost_column,
  cost_calculated_per,
  strength_column,
  list_of_code_names = NULL,
  list_of_code_freq = NULL,
  list_of_code_dose_unit = NULL,
  list_of_code_brand = NULL,
  eqdose_cov_tab = NULL,
  basis_strength_unit = NULL
)
}
\arguments{
\item{the_columns}{columns that are to be used to convert the data
from long to wide}

\item{ind_part_data_long}{IPD}

\item{name_med}{name of medication}

\item{brand_med}{brand name of medication if revealed}

\item{dose_med}{dose of medication used}

\item{unit_med}{unit of medication ; use null if its along with the dose}

\item{no_taken}{how many taken}

\item{freq_taken}{frequency of medication}

\item{timeperiod}{time period for cost calculation}

\item{unit_cost_data}{unit costs data}

\item{unit_cost_column}{column name of unit cost in unit_cost_data}

\item{cost_calculated_per}{column name of unit where the cost is calculated}

\item{strength_column}{column column name that contain strength of
medication}

\item{list_of_code_names}{if names is coded, give the code:name pairs,
optional}

\item{list_of_code_freq}{if frequency is coded, give the
code:frequency pairs, optional}

\item{list_of_code_dose_unit}{if unit is coded, give the code:unit pairs,
optional}

\item{list_of_code_brand}{if brand names  are coded, give the code:brand
pairs, optional}

\item{eqdose_cov_tab}{table to get the conversion factor for equivalent
doses, optional}

\item{basis_strength_unit}{strength unit to be taken as basis
required for total medication calculations}
}
\value{
the calculated cost of tablets along with original data
}
\description{
Function to estimate the cost of tablets when IPD is in long format
}
\examples{
med_costs_file <- system.file("extdata", "medicaton_costs_all.xlsx",
package = "packDAMipd")
data_file <- system.file("extdata", "medication_all.xlsx",
package = "packDAMipd")
ind_part_data <- load_trial_data(data_file)
med_costs <- load_trial_data(med_costs_file)
conv_file <- system.file("extdata", "Med_calc.xlsx", package = "packDAMipd")
table <- load_trial_data(conv_file)
names <- colnames(ind_part_data)
ending <- length(names)
ind_part_data_long <- tidyr::gather(ind_part_data, measurement, value,
names[2]:names[ending], factor_key = TRUE)
the_columns <- c("measurement", "value")
res <- microcosting_tablets_long(the_columns,
ind_part_data_long = ind_part_data_long, name_med = "tab_name",
brand_med = "tab_brand", dose_med = "tab_strength",
unit_med = "tab_str_unit",
no_taken = "tab_no_taken", freq_taken = "tab_frequency",
timeperiod = "2 months",unit_cost_data = med_costs,
unit_cost_column = "UnitCost", cost_calculated_per  = "Basis",
strength_column = "Strength", list_of_code_names = NULL,
list_of_code_freq = NULL,list_of_code_dose_unit = NULL,
eqdose_cov_tab = table, basis_strength_unit = "mg")
}
