% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audit_deps.R
\name{get_vulnerabilities}
\alias{get_vulnerabilities}
\title{Extract vulnerabilities

Parse the audit data frame (obtained via \code{audit_deps}), and extract
the vulnerabilities.}
\usage{
get_vulnerabilities(audit)
}
\arguments{
\item{audit}{Output from \code{audit_deps}.}
}
\description{
Extract vulnerabilities

Parse the audit data frame (obtained via \code{audit_deps}), and extract
the vulnerabilities.
}
\examples{
\donttest{
# Audit installed packages
# This calls installed.packages()
# pkgs = audit_deps()

# Or pass your own packages
pkgs = data.frame(package = c("abind", "acepack"),
                  version = c("1.4-5", "1.4.1"))
deps = audit_deps(pkgs)
get_vulnerabilities(deps)
}
}
