% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSWQuery.R
\docType{class}
\name{CSWQuery}
\alias{CSWQuery}
\title{CSWQuery}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an CSW Query
}
\description{
CSWQuery
}
\section{Methods}{

\describe{
 \item{\code{new(elementSetName, constraint, typeNames, serviceVersion)}}{
   This method is used to instantiate an CSWQUery object. The \code{elementSetName} can be 
   either "full" (default), "brief" or "summary". A constraint \code{CSWConstraint} can be
   defined for the query. The \code{typeNames} indicates to query (default "csw:Record").
   The \code{serviceVersion} gives the CSW service version (default "2.0.2")
 }
}
}

\examples{
  #CSWQuery - elementSetName
  query_full <- CSWQuery$new()
  query_brief <- CSWQuery$new(elementSetName = "brief")
  query_summary <- CSWQuery$new(elementSetName = "summary")
  
  #CSWQuery - cqlText with title
  cons <- CSWConstraint$new(cqlText = "dc:title like '\%ips\%'")
  query <- CSWQuery$new(constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / AnyText
  filter <- OGCFilter$new( PropertyIsLike$new("csw:AnyText", "\%Physio\%"))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / AnyText Equal
  filter <- OGCFilter$new( PropertyIsEqualTo$new("csw:AnyText", "species"))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / AnyText And Not
  filter <- OGCFilter$new(And$new(
    PropertyIsLike$new("csw:AnyText", "\%lorem\%"),
    PropertyIsLike$new("csw:AnyText", "\%ipsum\%"),
    Not$new(
      PropertyIsLike$new("csw:AnyText", "\%dolor\%")
    )
  ))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(constraint = cons)
 
  #CSW 2.0.2 - Query - Filter / AnyText And nested Or
  filter <- OGCFilter$new(And$new(
    PropertyIsEqualTo$new("dc:title", "Aliquam fermentum purus quis arcu"),
    PropertyIsEqualTo$new("dc:format", "application/pdf"),
    Or$new(
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Dataset"),
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Service"),
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Image"),
      PropertyIsEqualTo$new("dc:type", "http://purl.org/dc/dcmitype/Text")
    )
  ))
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(elementSetName = "brief", constraint = cons)
  
  #CSW 2.0.2 - Query - Filter / BBOX
  bbox <- matrix(c(-180,180,-90,90), nrow = 2, ncol = 2, byrow = TRUE,
                 dimnames = list(c("x", "y"), c("min","max")))
  filter <- OGCFilter$new( BBOX$new(bbox = bbox) )
  cons <- CSWConstraint$new(filter = filter)
  query <- CSWQuery$new(elementSetName = "brief", constraint = cons)
  
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{OGC}
\keyword{Query}
