% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrmRoute.R
\name{osrmRoute}
\alias{osrmRoute}
\title{Get the Shortest Path Between Two Points}
\usage{
osrmRoute(src, dst, overview = "simplified", sp = FALSE)
}
\arguments{
\item{src}{a numeric vector of identifier, longitude and latitude (WGS84), a 
SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the origine 
point.}

\item{dst}{a numeric vector of identifier, longitude and latitude (WGS84), a 
SpatialPointsDataFrame or a SpatialPolygonsDataFrame of the destination 
point.}

\item{overview}{"full", "simplified" or FALSE. Add geometry either full (detailed), simplified 
according to highest zoom level it could be display on, or not at all.}

\item{sp}{if sp is TRUE the function returns a SpatialLinesDataFrame.}
}
\value{
If sp is FALSE, a data frame is returned. It contains the longitudes and latitudes of 
the travel path between the two points.\cr
If sp is TRUE a SpatialLinesDataFrame is returned. It contains 4 fields : 
identifiers of origine and destination, travel time in minutes and travel distance in 
kilometers.\cr
If overview is FALSE, a named numeric vector is returned. It contains travel time (in minutes) 
and travel distance (in kilometers).
}
\description{
Build and send an OSRM API query to get the travel geometry between two points.
This function interfaces the \emph{route} OSRM service.
}
\examples{
\dontrun{
# Load data
data("berlin")

# Travel path between points
route <- osrmRoute(src = apotheke.df[1, c("id", "lon","lat")],
                   dst = apotheke.df[15, c("id", "lon","lat")])
# Display the path
plot(route[,1:2], type = "l", lty = 2, asp =1)
points(apotheke.df[c(1,15),2:3], col = "red", pch = 20, cex = 1.5)
text(apotheke.df[c(1,15),2:3], labels = c("A","B"), pos = 1)

# Travel path between points - output a SpatialLinesDataFrame
route2 <- osrmRoute(src = c("A", 13.23889, 52.54250),
                    dst = c("B", 13.45363, 52.42926),
                    sp = TRUE, overview = "full")

# Display the path
plot(route2, lty = 1,lwd = 4, asp = 1)
plot(route2, lty = 1, lwd = 1, col = "white", add=TRUE)
points(x = c(13.23889, 13.45363), y = c(52.54250,52.42926), 
       col = "red", pch = 20, cex = 1.5)
text(x = c(13.23889, 13.45363), y = c(52.54250,52.42926), 
     labels = c("A","B"), pos = 2)

# Input is SpatialPointsDataFrames
route3 <- osrmRoute(src = apotheke.sp[1,], dst = apotheke.sp[2,], sp = TRUE)
route3@data
}
}
