% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/osrmTableOD.R
\name{osrmTableOD}
\alias{osrmTableOD}
\title{Get Travel Time Matrices Between Origins and Destinations}
\usage{
osrmTableOD(dfo, ido, xo, yo, dfd, idd, xd, yd, limit = 100)
}
\arguments{
\item{dfo}{data frame containing origin points identifiers, longitudes and latitudes
(WGS84).}

\item{ido}{identifier field in dfo.}

\item{xo}{longitude field in dfo.}

\item{yo}{latitude field in dfo.}

\item{dfd}{data frame containing destination points identifiers, longitudes and latitudes
(WGS84).}

\item{idd}{identifier field in dfd.}

\item{xd}{longitude field in dfd.}

\item{yd}{latitude field in dfd.}

\item{limit}{table query limit of osrm API in use. The default value (100) is
the public API limit.}
}
\value{
A matrix of time distances (in minutes) between origins and
destinations is returned.
}
\description{
Build and send OSRM API queries to get travel time matrices between set of origin points and set of destination points
}
\note{
This function is a wraper around osrmTable. Multiple calls allow to
obtain a matrix between different sets of origins and destinations. A default delay is set between
calls (1 sec) to be gentle with the public API. You can modify this delay if you use your own server:
\code{options(osrm.delay = your_delay_value)}.
}
\examples{
# Load data
data("com")
# Travel time matrix
distcom <- osrmTableOD(dfo = com[1:50,], ido = "comm_id", xo =  "lon", yo =  "lat",
                       dfd = com[51:100,], idd = "comm_id", xd = "lon", yd = "lat")
# First 5 rows and columns
distcom[1:5,1:5]
}
\seealso{
\link{osrmTable}, \link{osrmTableErrors}
}

