% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata-df.R
\name{osmdata_data_frame}
\alias{osmdata_data_frame}
\title{Return an OSM Overpass query as a \link{data.frame} object.}
\usage{
osmdata_data_frame(q, doc, quiet = TRUE, stringsAsFactors = FALSE)
}
\arguments{
\item{q}{An object of class \code{overpass_query} constructed with
\link{opq} and \link{add_osm_feature}. May be be omitted,
in which case the attributes of the \link{data.frame} will not include
the query.}

\item{doc}{If missing, \code{doc} is obtained by issuing the overpass query,
\code{q}, otherwise either the name of a file from which to read data,
or an object of class \pkg{xml2} returned from
\link{osmdata_xml}.}

\item{quiet}{suppress status messages.}

\item{stringsAsFactors}{Should character strings in the 'data.frame' be
coerced to factors?}
}
\value{
A \code{data.frame} with id, type and tags of the the objects from the
query.
}
\description{
Return an OSM Overpass query as a \link{data.frame} object.
}
\details{
If you are not interested in the geometries of the results, it's a
good option to query for objects that match the features only and forget
about members of the ways and relations. You can achieve this by passing
the parameter \code{body = "tags"} to \code{\link{opq}}.
}
\examples{
\dontrun{
hampi_df <- opq ("hampi india") \%>\%
    add_osm_feature (key = "historic", value = "ruins") \%>\%
    osmdata_data_frame ()
attr (hampi_df, "bbox")
attr (hampi_df, "overpass_call")
attr (hampi_df, "meta")
}
}
\seealso{
Other extract: 
\code{\link{osmdata_sc}()},
\code{\link{osmdata_sf}()},
\code{\link{osmdata_sp}()},
\code{\link{osmdata_xml}()}
}
\concept{extract}
