% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngd_api.R
\name{query_ngd}
\alias{query_ngd}
\alias{query_ngd.character}
\alias{query_ngd.qExtent}
\alias{query_ngd.geos_geometry}
\alias{query_ngd.sf}
\alias{query_ngd.sfc}
\title{Query the OS NGD Features API}
\usage{
query_ngd(x, ...)

\method{query_ngd}{character}(
  x,
  collection,
  crs = "crs84",
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)

\method{query_ngd}{qExtent}(
  x,
  collection,
  crs = "crs84",
  start_datetime,
  end_datetime,
  cql_filter,
  filter_crs,
  max_results = 100,
  offset = 0,
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)

\method{query_ngd}{geos_geometry}(
  x,
  collection,
  crs = "crs84",
  start_datetime,
  end_datetime,
  cql_filter,
  filter_crs,
  max_results = 100,
  offset = 0,
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)

\method{query_ngd}{sf}(
  x,
  collection,
  crs = "crs84",
  start_datetime,
  end_datetime,
  cql_filter,
  filter_crs,
  max_results = 100,
  offset = 0,
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)

\method{query_ngd}{sfc}(
  x,
  collection,
  crs = "crs84",
  start_datetime,
  end_datetime,
  cql_filter,
  filter_crs,
  max_results = 100,
  offset = 0,
  key = get_os_key(),
  returnType = c("geojson", "list", "sf"),
  ...
)
}
\arguments{
\item{x}{Object defining the query parameters, including feature IDs,
extents, or spatial objects from which extents can be determined If
\code{x} is \code{NULL} or missing with other options specified by name,
then the first \code{max_results} of the collection will be returned.}

\item{...}{Additional parameters (not currently used).}

\item{collection}{(character) The name of the NGD Collection to query
(required). See \code{list_ngd_collections()}.}

\item{crs}{(character or numeric)  The CRS for the returned features, either
in the format "epsg:xxxx" or an EPSG number. e.g. British National Grid can
be supplied as "epsg:27700" or 27700. Available CRS values are: EPSG:27700,
EPSG:4326, EPSG:7405, EPSG:3857, and CRS84. Defaults to CRS84.}

\item{key}{(character) OS API key. Default action is to search for an
environment variable using \code{get_os_key()}.}

\item{returnType}{(character) Return the query results as the raw
\code{'geojson'}, a nested \code{'list'} object containing the returns,
or convert them into Simple Features and return an object of class
\code{'sf'}.}

\item{start_datetime}{(datetime or string)  Selects features that have a
temporal property after the given start time. If you want to query a single
timestamp, provide the same value to both \code{start_datetime} and
\code{end_datetime}.}

\item{end_datetime}{(datetime or string) Selects features that have a
temporal property before the given end time. If you want to query a single
timestamp, provide the same value to both \code{start_datetime} and
\code{end_datetime}.}

\item{cql_filter}{(character) A filter query in CQL format. More information
about supported CQL operators can be found at
\url{https://osdatahub.os.uk/docs/ofa/technicalSpecification}.}

\item{filter_crs}{(character or numeric) The CRS for a given CQL query (if
required), either in the format “epsg:xxxx” or an epsg number. e.g. British
National Grid can be supplied as “epsg:27700” or 27700 Available CRS values
are: EPSG:27700, EPSG:4326, EPSG:7405, EPSG:3857, and CRS84. Defaults to
CRS84.}

\item{max_results}{(numeric) The maximum number of features to return.
Default is 100 which is the max return per page from the Data Hub.}

\item{offset}{(numeric) The offset number skips past the specified number of
features in the collection. Used to page through results. Default is 0.}
}
\value{
A GeoJSON string with the results of the API query, a list object,
or an object of class \code{sf} based on the \code{returnType} parameter.
}
\description{
Retrieve features from a given Collection of the National Geographic
Database in the Ordnance Survey Data Hub.
}
\details{
The value of \code{x} determines the type of query that is executed
against the NGD API. When \code{x} is missing or set to \code{NULL} the
first n=\code{max_results} features are returned. If a character string of
an OSID is supplied as \code{x}, then that one feature from the collection
will be returned.

When \code{x} is present \code{query_ngd()} will attempt to derive an
extent from it. The \code{extent_from_*} family of functions are used and
can be passed to \code{query_ngd} as a more verbose option. The one
exception to this, \code{extent_from_grid_ref} must be used to create an
extent and query a BNG grid reference.

The \code{start_datetime} and \code{end_datetime} parameters specify a
valid date-time with UTC time zone (Z). Leave either empty to specify an
open start/end interval. Only features that have a temporal geometry
('versionavailablefromdate' or 'versionavailabletodate') that intersect the
value in the datetime parameter are selected. Example
'2021-12-12T13:20:50Z'.

More information on the structure and data in the NGD is available from:
\url{https://osngd.gitbook.io/osngd/}. Technical details on the NGD API are
documented on the Data Hub:
\url{https://osdatahub.os.uk/docs/ofa/technicalSpecification}.
}
\examples{
\dontshow{if (has_os_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Return the first 50 features in the collection.
results <- query_ngd(collection = 'bld-fts-buildingline-1', max_results = 50)

# Return the most recent representation of a feature ID.
results <- query_ngd('0000013e-5fed-447d-a627-dae6fb215138',
                     collection = 'bld-fts-buildingline-1')

# Use an ONS geography to define a query extent.
results <- query_ngd(extent_from_ons_code('E05002470'),
                     collection = 'bld-fts-buildingpart-1')

# Use an BNG reference to define a query extent.
results <- query_ngd(extent_from_bng("SU3715"),
                     collection = 'bld-fts-buildingpart-1')

# Use a spatial object to define a query extent.
# Return the features converted to a spatial object.
results <- query_ngd(sf::st_read('path/to/file.shp'),
                     collection = 'bld-fts-buildingpart-1',
                     returnType = 'sf')

# Add a temporal filter to query.
results <- query_ngd(collection = 'bld-fts-buildingline-1',
                     max_results = 50,
                     start_datetime = '2021-12-12 13:20:50')
\dontshow{\}) # examplesIf}
}
\seealso{
\link{extent}
}
