% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extent.R
\name{extent_from_ons_code}
\alias{extent_from_ons_code}
\title{Retrieve an extent for ONS geographies}
\usage{
extent_from_ons_code(ons_code, returnType = c("qExtent", "geos", "wkt"))
}
\arguments{
\item{ons_code}{(character) A single ONS code representing a statistical
area.}

\item{returnType}{(character) Define the object returned. The default is
\code{'qExtent'} to define a "query extent" object expected internally by
\code{osdatahub}. Other options are \code{'wkt'} to return the geometry in
Well-Known Text format or \code{'geos'} to return an object of class
\code{geos}.}
}
\value{
The coordinates of the polygon boundary.
}
\description{
Retrieve an extent for ONS geographies
}
\details{
The Office for National Statistics (ONS) maintains a source of
official geographies for the UK, such as county boundaries, electoral
wards, parishes, and census output areas. These boundaries are commonly
used for data analysis, particularly of socio-economic factors. A full list
of available ONS geographies can be found here:
\url{https://statistics.data.gov.uk:443/atlas/resource?uri=http://statistics.data.gov.uk/id/statistical-geography/K02000001}.

When returning a \code{geos} object, the coordinate reference system
attribute will be set to CRS:84 by default and not to a full CRS
definition.

The \code{qExtent} return option identifies a simple class of objects
containing a polygon of the extent in WKT format, the bounding box
coordinates, and a CRS string. It is intended to be used internally by
functions in \code{osdatahub}.
}
\examples{
\donttest{
ext <- extent_from_ons_code("E05002470", returnType = 'wkt')
}

}
\seealso{
\link{extent}
}
