% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloads_api.R
\name{download_os_datapackages}
\alias{download_os_datapackages}
\alias{download_os_datapackages.package_list}
\alias{download_os_datapackages.data.frame}
\alias{download_os_datapackages.numeric}
\title{Download OS premium data packages}
\usage{
download_os_datapackages(product, ...)

\method{download_os_datapackages}{package_list}(
  product,
  file_name,
  output_dir,
  overwrite = FALSE,
  key = get_os_key(),
  ...
)

\method{download_os_datapackages}{data.frame}(
  product,
  version,
  file_name,
  output_dir,
  overwrite = FALSE,
  key = get_os_key(),
  ...
)

\method{download_os_datapackages}{numeric}(
  product,
  version,
  file_name,
  output_dir,
  overwrite = FALSE,
  key = get_os_key(),
  ...
)
}
\arguments{
\item{product}{A \code{product_list} object retrieved and filtered using
\code{list_os_datapackages}. Alternatively, a \code{data.frame} object or
integer or character string of a product ID that can be filtered further.}

\item{...}{Additional parameters. Not currently used.}

\item{file_name}{(character) Filter downloads to only include those with this
file name. Optional.}

\item{output_dir}{Path to the directory where the downloaded files will be
saved.}

\item{overwrite}{Boolean. Should existing files be overwritten? Default is
\code{FALSE}.}

\item{key}{(character) OS API key. Default action is to search for an
environment variable using \code{get_os_key()}.}

\item{version}{(numeric or character) Retrieve information on a specific
version(s) of a data product. Required when \code{product} is a
\code{data.frame}.}
}
\value{
Silently returns the directory where the downloaded files are
stored.
}
\description{
Main function for downloading OS data packages to your local machine.
}
\details{
The OS Downloads API assists with the discovery and download of OS
OpenData and OS premium data packages. This function is used as the main
step to download data packages to your local machine. It is designed to
work best after \code{list_os_datapackages} is first used to search and
filter for the specific download product. The \code{package_list} returned
by the listing step can be used as the input value to download the desired
files. Alternatively, it is possible to supply a product and version IDs
directly when they are already known.

Before downloading a data package, it must be ordered online. See:
\url{https://osdatahub.os.uk/downloads/packages}.

For more information on the Downloads API, see
\url{https://osdatahub.os.uk/docs/downloads/technicalSpecification}.
}
\examples{
\dontrun{
# Search and filter available open products.
pkg_list <- list_os_datapackages()

# Use the package list to initiate a download.
# Note: 'version' will vary.
download_os_datapackages(pkg_list, version = 123, output_dir = tempdir())
}

}
\seealso{
list_os_datapackages
}
