% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_base_font}
\alias{wb_base_font}
\alias{wb_set_base_font}
\alias{wb_get_base_font}
\title{Get / set the default font in a workbook}
\usage{
wb_set_base_font(
  wb,
  font_size = 11,
  font_color = wb_color(theme = "1"),
  font_name = "Calibri",
  ...
)

wb_get_base_font(wb)
}
\arguments{
\item{wb}{A workbook object}

\item{font_size}{font size}

\item{font_color}{font color}

\item{font_name}{Name of a font}

\item{...}{additional arguments}
}
\description{
Modify / get the default font for the workbook.
}
\details{
The font name is not validated in anyway. Excel replaces unknown font names
with Arial. Base font is black, size 11, Calibri.
}
\examples{
## create a workbook
wb <- wb_workbook()
wb$add_worksheet("S1")
## modify base font to size 10 Arial Narrow in red
wb$set_base_font(fontSize = 10, fontColor = "#FF0000", fontName = "Arial Narrow")

wb$add_data("S1", iris)
wb$add_data_table("S1", x = iris, startCol = 10) ## font color does not affect tables

## get the base font
## create a workbook
wb <- wb_workbook()
wb_get_base_font(wb)

## modify base font to size 10 Arial Narrow in red
wb$set_base_font(fontSize = 10, fontColor = "#FF0000", fontName = "Arial Narrow")

wb_get_base_font(wb)
}
\seealso{
Other workbook wrappers: 
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_col_widths}},
\code{\link{wb_copy_cells}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_grouping}},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
