% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{cell_style}
\alias{cell_style}
\alias{wb_get_cell_style}
\alias{wb_set_cell_style}
\title{get and set cell style}
\usage{
wb_get_cell_style(wb, sheet = current_sheet(), dims)

wb_set_cell_style(wb, sheet = current_sheet(), dims, style)
}
\arguments{
\item{wb}{wb}

\item{sheet}{sheet}

\item{dims}{dims}

\item{style}{style}
}
\value{
wb_get_cell_style returns the style id as character

wb_set_cell_style returns the workbook invisible
}
\description{
get and set cell style
}
\examples{
# set a style in b1
wb <- wb_workbook()$add_worksheet()$
  add_numfmt(dims = "B1", numfmt = "#,0")

# get style from b1 to assign it to a1
numfmt <- wb$get_cell_style(dims = "B1")

# assign style to a1
wb$set_cell_style(dims = "A1", style = numfmt)
}
