% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{create_sparklines}
\alias{create_sparklines}
\title{create sparklines used in \code{add_sparline()}}
\usage{
create_sparklines(
  sheet = current_sheet(),
  dims,
  sqref,
  type = NULL,
  negative = NULL,
  displayEmptyCellsAs = "gap",
  markers = NULL,
  high = NULL,
  low = NULL,
  first = NULL,
  last = NULL,
  colorSeries = wb_colour(hex = "FF376092"),
  colorNegative = wb_colour(hex = "FFD00000"),
  colorAxis = wb_colour(hex = "FFD00000"),
  colorMarkers = wb_colour(hex = "FFD00000"),
  colorFirst = wb_colour(hex = "FFD00000"),
  colorLast = wb_colour(hex = "FFD00000"),
  colorHigh = wb_colour(hex = "FFD00000"),
  colorLow = wb_colour(hex = "FFD00000")
)
}
\arguments{
\item{sheet}{sheet}

\item{dims}{dims}

\item{sqref}{sqref}

\item{type}{type}

\item{negative}{negative}

\item{displayEmptyCellsAs}{displayEmptyCellsAs}

\item{markers}{markers add marker to line}

\item{high}{highlight highest value}

\item{low}{highlight lowest value}

\item{first}{highlight first value}

\item{last}{highlight last value}

\item{colorSeries}{colorSeries}

\item{colorNegative}{colorNegative}

\item{colorAxis}{colorAxis}

\item{colorMarkers}{colorMarkers}

\item{colorFirst}{colorFirst}

\item{colorLast}{colorLast}

\item{colorHigh}{colorHigh}

\item{colorLow}{colorLow}
}
\description{
create sparklines used in \code{add_sparline()}
}
\details{
the colors are all predefined to be rgb. Maybe theme colors can be
used too.
}
\examples{
# create sparklineGroup
sparklines <- c(
  create_sparklines("Sheet 1", "A3:L3", "M3", type = "column", first = "1"),
  create_sparklines("Sheet 1", "A2:L2", "M2", markers = "1"),
  create_sparklines("Sheet 1", "A4:L4", "M4", type = "stacked", negative = "1")
)

t1 <- AirPassengers
t2 <- do.call(cbind, split(t1, cycle(t1)))
dimnames(t2) <- dimnames(.preformat.ts(t1))

wb <- wb_workbook()$
  add_worksheet("Sheet 1")$
  add_data(x = t2)$
  add_sparklines(sparklines = sparklines)

}
