% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/writexlsx.R
\name{write.xlsx}
\alias{write.xlsx}
\title{write directly to an xlsx file}
\usage{
write.xlsx(x, file, asTable = FALSE, ...)
}
\arguments{
\item{x}{object or a list of objects that can be handled by \code{\link{writeData}} to write to file}

\item{file}{xlsx file name}

\item{asTable}{write using writeDataTable as opposed to writeData}

\item{...}{optional parameters to pass to functions:
\itemize{
  \item{createWorkbook}
  \item{addWorksheet}
  \item{writeData}
  \item{saveWorkbook}
}

see details.}
}
\value{
A workbook object
}
\description{
write directly to an xlsx file
}
\details{
Optional parameters are:
\itemize{
  \item{\bold{creator}}{ A string specifying the workbook author}
  \item{\bold{sheetName}}{ Name of the worksheet}
  \item{\bold{gridLines}}{ A logical. If \code{FALSE}, the worksheet grid lines will be hidden.}
  \item{\bold{startCol}}{ A vector specifiying the starting column(s) to write df}
  \item{\bold{startRow}}{ A vector specifiying the starting row(s) to write df}
  \item{\bold{xy}}{ An alternative to specifying startCol and startRow individually.
 A vector of the form c(startCol, startRow)}
  \item{\bold{colNames or col.names}}{ If \code{TRUE}, column names of x are written.}
  \item{\bold{rowNames or row.names}}{ If \code{TRUE}, row names of x are written.}
  \item{\bold{headerStyle}}{ Custom style to apply to column names.}
  \item{\bold{borders}}{ Either "surrounding", "columns" or "rows" or NULL.  If "surrounding", a border is drawn around the
data.  If "rows", a surrounding border is drawn a border around each row. If "columns", a surrounding border is drawn with a border
between each column.  If "\code{all}" all cell borders are drawn.}
  \item{\bold{borderColour}}{ Colour of cell border}
  \item{\bold{borderStyle}}{ Border line style.}
  \item{\bold{overwrite}}{ Overwrite existing file (Defaults to TRUE as with write.table)}
}

columns of x with class Date or POSIXt are automatically
styled as dates and datetimes respectively.
}
\examples{
## write to working directory
options("openxlsx.borderColour" = "#4F80BD") ## set default border colour
write.xlsx(iris, file = "writeXLSX1.xlsx", colNames = TRUE, borders = "columns")
write.xlsx(iris, file = "writeXLSX2.xlsx", colNames = TRUE, borders = "surrounding")


hs <- createStyle(textDecoration = "BOLD", fontColour = "#FFFFFF", fontSize=12,
                  fontName="Arial Narrow", fgFill = "#4F80BD")

write.xlsx(iris, file = "writeXLSX3.xlsx", colNames = TRUE, borders = "rows", headerStyle = hs)

## Lists elements are written to individual worksheets, using list names as sheet names if available
l <- list("IRIS" = iris, "MTCATS" = mtcars, matrix(runif(1000), ncol = 5))
write.xlsx(l, "writeList1.xlsx")

## different sheets can be given different parameters
write.xlsx(l, "writeList2.xlsx", startCol = c(1,2,3), startRow = 2,
           asTable = c(TRUE, TRUE, FALSE), withFilter = c(TRUE, FALSE, FALSE))
}
\author{
Alexander Walker
}
\seealso{
\code{\link{addWorksheet}}

\code{\link{writeData}}

\code{\link{createStyle}} for style parameters
}

