% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modland.R
\name{modland_search}
\alias{modland_search}
\alias{modland_download}
\title{Functions to interact with modLand}
\usage{
modland_search(text, ...)

modland_download(
  format,
  author,
  title,
  mirror = c("modland.com", "ftp.modland.com", "antarctica.no", "ziphoid.com",
    "exotica.org.uk"),
  read_fun = read_mod,
  ...
)
}
\arguments{
\item{text}{Search text, to look for on \href{https://modland.com/}{modland}.}

\item{...}{Arguments passed on to \code{read_fun}}

\item{format}{A single length \code{character} vector, indicating the
tracker file format. Can be obtained from a \code{modland_search()}.}

\item{author}{A single length \code{character} vector, indicating the
module author name. Can be obtained from a \code{modland_search()}.}

\item{title}{A single length \code{character} vector, indicating the
module title. Can be obtained from a \code{modland_search()}.}

\item{mirror}{A single length \code{character} vector. Should contain one of the
mirrors listed in the 'usage' section. Select a mirror site from which
the module file needs to be downloaded.}

\item{read_fun}{Function that accepts an URL first argument.
By default it is \code{\link[=read_mod]{read_mod()}} and is used to read the file.
You can replace it with other functions such as \code{ProTrackR2::pt2_read_mod()}.}
}
\value{
In case of \code{modland_search()} a \code{data.frame} with search
results are returned (or \code{NULL} if there are no results).

\code{modland_download()} will return the result of the function
specified by \code{read_fun}. By default it will return an \code{openmpt} class object.
}
\description{
\href{https://modland.com/}{ModLand} is an online archive containing over 400,000
module files. These functions allow you to search in and download from this archive.
}
\examples{
search_result <- modland_search("elekfunk mod")

## The URL in the search results will download a rendered
## ogg file. If you want to download te original mod file,
## use this: 
if (length(search_result) > 0) {
  mod <- modland_download(search_result$format[[1]],
                          search_result$author[[1]],
                          search_result$title[[1]])
}
}
\seealso{
\code{\link[=modarchive_search_mod]{modarchive_search_mod()}}
}
