% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openairmaps-package.R
\docType{package}
\name{openairmaps-package}
\alias{openairmaps}
\alias{openairmaps-package}
\title{openairmaps: Create Maps of Air Pollution Data}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Combine the air quality data analysis methods of 'openair' with the JavaScript 'Leaflet' (\url{https://leafletjs.com/}) library. Functionality includes plotting site maps, "directional analysis" figures such as polar plots, and air mass trajectories.
}
\details{
This is a companion package to \code{openair}, a UK NERC- and
Defra-funded R package for the analysis of data pertaining to pollution
monitoring and dispersion modelling.

As the R ecosystem has developed, R Markdown and, more recently, Quarto
have emerged as capable tools for combining data analysis with document
preparation. While these approaches can render typical .docx and .pdf
outputs, one of their most common output formats is the HTML document. This
format has many strengths, but a key one is interactivity; HTML widgets
allow documents to be more informative and engaging. Numerous packages have
been developed to easily develop these interactive widgets, such as
\code{plotly} and \code{dygraphs} for plots, \code{DT} for tables, and \code{leaflet} for maps.
The \code{openairmaps} package concerns itself with making \code{leaflet} maps.

Air quality data analysis — particularly as it pertains to long term
monitoring data — naturally lends itself to being visualised spatially on a
map. Monitoring networks are geographically distributed, and ignoring their
geographical context may lead to incomplete insights at best and incorrect
conclusions at worst! Furthermore, many air quality analysis tools are
directional, asking questions of the data along the lines of “do elevated
concentrations come from the North, South, East or West?” The natural
question that follows is “well, what actually is it to the
North/South/East/West that could be causing elevated concentrations?” — a
map can help answer that question straightforwardly.

The \code{openairmaps} package contains functions to visualise UK air quality
networks, and place "polar analysis" markers (like the \code{openair} \link[openair:polarPlot]{polar plot}) and airmass trajectory paths on maps. It uses
a similar syntax to the \code{openair} package, which should make moving between
the two relatively seamless.
}
\seealso{
The \code{openair} package, from which \code{openairmaps} is based.

The \code{worldmet} package, which simplifies the access of
meteorological data in R.

The \href{https://bookdown.org/david_carslaw/openair/}{openair book} for
more in-depth documentation of \code{openair} and \code{openairmaps}.
}
\author{
\strong{Maintainer}: Jack Davison \email{davison.jack.jd@gmail.com}

Authors:
\itemize{
  \item David Carslaw \email{david.carslaw@york.ac.uk}
}

}
\keyword{internal}
