% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_create}
\alias{opal.resource_create}
\title{Create a resource reference in a project}
\usage{
opal.resource_create(
  opal,
  project,
  name,
  url,
  description = NULL,
  format = NULL,
  package = NULL,
  identity = NULL,
  secret = NULL
)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project.}

\item{name}{Name of the resource in the project.}

\item{url}{The URL of the resource.}

\item{description}{The description of the resource (optional).}

\item{format}{The format of the data described by the resource (optional).}

\item{package}{The R package to be loaded prior to the assignment of the resource (optional).}

\item{identity}{The identity key or username to be used when accessing the resource (optional).}

\item{secret}{The secret key or password to be used when accessing the resource (optional).}
}
\description{
Create a resource reference in a project
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resource_create(o, 'RSRC', 'CNSIM4', 
  url = 'opal+https://opal-demo.obiba.org/ws/files/projects/RSRC/CNSIM3.zip', 
  format = 'csv', secret = 'EeTtQGIob6haio5bx6FUfVvIGkeZJfGq')
opal.logout(o)
}
}
\seealso{
Other project functions: 
\code{\link{opal.project_create}()},
\code{\link{opal.project_delete}()},
\code{\link{opal.project_exists}()},
\code{\link{opal.projects}()},
\code{\link{opal.project}()},
\code{\link{opal.resource_exists}()},
\code{\link{opal.resource_extension_create}()},
\code{\link{opal.resource_get}()},
\code{\link{opal.resources}()},
\code{\link{opal.resource}()}
}
\concept{project functions}
