% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.r
\name{opal.resources_perm_add}
\alias{opal.resources_perm_add}
\title{Add or update a permission on any resource}
\usage{
opal.resources_perm_add(opal, project, subject, type = "user", permission)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{The project name.}

\item{subject}{A vector of subject identifiers: user names or group names (depending on the type).}

\item{type}{The type of subject: user (default) or group.}

\item{permission}{The permission to apply: view, administrate. The 'view' permission
is suitable for DataSHIELD operations.}
}
\description{
Add or update a global permission on the project's resources
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resources_perm_add(o, 'CNSIM', c('andrei', 'valentina'), 'user', 'view')
opal.resources_perm(o, 'CNSIM')
opal.resources_perm_delete(o, 'CNSIM', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
