% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmo.dictionary.R
\name{harmo.dictionary_apply}
\alias{harmo.dictionary_apply}
\title{Apply the dictionary to a tibble}
\usage{
harmo.dictionary_apply(tibble, variables, categories = NULL)
}
\arguments{
\item{tibble}{Tibble to be decorated.}

\item{variables}{A data frame with one row per variable (column name) and then one column per property/attribute.}

\item{categories}{A data frame with one row per category (columns variable and name) and then column per property/attribute.}
}
\description{
Apply the dictionary described in a Opal Excel format as attributes of the tibble's columns.
}
\examples{
\donttest{
data <- tibble::as_tibble(mtcars)
variables <- tibble::tribble(
  ~name, ~valueType, ~`label:en`,  ~`Namespace::Name`, ~unit, ~repeatable, ~index,
  "mpg", "decimal", "Mpg label",  "Value1", "years", 0, 1,
  "cyl", "decimal", "Cyl label",  "Value2", "kg/m2", 0, 2,
  "disp", "decimal", "Disp label", NA, NA, 1, 3
)
categories <- tibble::tribble(
  ~variable, ~name, ~missing, ~`label:en`, ~`label:fr`,
  "cyl", "4", 0, "Four", "Quatre",
  "cyl", "6", 0, "Six", "Six",
  "cyl", "8", 1, "Height", "Huit"
)
data <- harmo.dictionary_apply(data, variables, categories)
}
}
