% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds_onemap.R
\name{mds_onemap}
\alias{mds_onemap}
\title{OneMap interface with MDSMap package with possibilitie of multipoint distances estimation}
\usage{
mds_onemap(input.seq, out.file = "out.file",
  mds.graph.file = "NULL.pdf", p = NULL, n = NULL, ispc = TRUE,
  displaytext = FALSE, weightfn = "lod2", mapfn = "haldane",
  hmm = TRUE, mds.seq = TRUE)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}}

\item{out.file}{path to the generated MDSMap input file.}

\item{mds.graph.file}{path to the graphic generated by MDSMap}

\item{p}{Integer - the penalty for deviations from the sphere - higher p
forces points more closely onto a sphere.}

\item{n}{Vector of integers or strings containing markers to be omitted from
the analysis.}

\item{ispc}{Logical determining the method to be used to estimate the map. By default 
this is TRUE and the method of principal curves will be used. If FALSE then the 
constrained MDS method will be used.}

\item{displaytext}{Shows markers names in analysis graphic view}

\item{weightfn}{Character string specifying the values to use for the weight
matrix in the MDS 'lod2' or 'lod'.}

\item{mapfn}{Character string specifying the map function to use on the
recombination fractions 'haldane' is default, 'kosambi' or 'none'.}

\item{hmm}{Multipoint genetic distance estimation}

\item{mds.seq}{When some pair of markers do not follow the linkage criteria, 
if \code{TRUE} one of the markers is removed and mds is performed again.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{name of the object of class \code{onemap} with the raw
data.} \item{twopt}{name of the object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
For a given sequence of markers, apply mds method described in Preedy and Hackett (2016)
using MDSMap package to ordering markers and estimates the genetic distances with OneMap
multipoint approach. Also gives MDSMap input file format for directly analysis in this package.
}
\details{
For better description about MDS method, see MDSMap package vignette.
}
\references{
Preedy, K. F.  and  Hackett, C. A.  (2016). A rapid marker ordering approach for high-density
genetic linkage maps in experimental autotetraploid populations using multidimensional
scaling. \emph{Theoretical and Applied Genetics} 129: 2117-2132

Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia, A. A. F.
(2009) Evaluation of algorithms used to order markers on genetics maps.
\emph{Heredity} 103: 494-502.

Wu, R., Ma, C.-X., Painter, I. and Zeng, Z.-B. (2002a) Simultaneous maximum
likelihood estimation of linkage and linkage phases in outcrossing species.
\emph{Theoretical Population Biology} 61: 349-363.

Wu, R., Ma, C.-X., Wu, S. S. and Zeng, Z.-B. (2002b). Linkage mapping of
sex-specific differences. \emph{Genetical Research} 79: 85-96
}
\seealso{
\url{https://CRAN.R-project.org/package=MDSMap}.
}
\author{
Cristiane Taniguti, \email{chtaniguti@usp.br}
}
