% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addSettings.R
\name{addSettings}
\alias{addSettings}
\title{Add settings columns to a \verb{<summarised_result>} object}
\usage{
addSettings(result, settingsColumn = settingsColumns(result))
}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{settingsColumn}{Settings to be added as columns, by default
\code{settingsColumns(result)} will be added. If NULL or empty character vector,
no settings will be added.}
}
\value{
A \verb{<summarised_result>} object with the added setting columns.
}
\description{
Add settings columns to a \verb{<summarised_result>} object
}
\examples{
{
  library(dplyr)
  library(omopgenerics)

  x <- tibble(
    "result_id" = as.integer(c(1, 2)),
    "cdm_name" = c("cprd", "eunomia"),
    "group_name" = "cohort_name",
    "group_level" = "my_cohort",
    "strata_name" = "sex",
    "strata_level" = "male",
    "variable_name" = "Age group",
    "variable_level" = "10 to 50",
    "estimate_name" = "count",
    "estimate_type" = "numeric",
    "estimate_value" = "5",
    "additional_name" = "overall",
    "additional_level" = "overall"
  ) |>
    newSummarisedResult(settings = tibble(
      "result_id" = c(1, 2), "custom" = c("A", "B")
    ))

  x

  x |> addSettings()
}

}
