% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden_markov.R
\name{ll_hmm}
\alias{ll_hmm}
\title{Compute HMM log-likelihood}
\usage{
ll_hmm(theta, data, states, sdd, neg = FALSE, ...)
}
\arguments{
\item{theta}{A \code{numeric} vector, the model parameters (if any) in the following order:
\enumerate{
\item column-wise non-diagonal entries of the transition probability matrix
\item the initial state distribution
\item parameters of the state-dependent distribution for each state
}}

\item{data}{A \code{numeric} vector, the time series data.}

\item{states}{An \code{integer}, the number of states.}

\item{sdd}{A \code{character}, defining the type of state-dependent distribution.
Print \code{sdds_dictionary} for possible values.}

\item{neg}{Set to \code{TRUE} to return the negative log-likelihood value.}

\item{...}{Currently not used.}
}
\value{
A \code{numeric}, the log-likelihood value at \code{theta} given \code{data}.
}
\description{
This function computes the log-likelihood of a hidden Markov model.
}
\examples{
states <- 2
sdd <- "normal"
x <- simulate_hmm(
  Tp = 100, states = states, sdd = sdd, mean = c(-1, 1), sd = c(1, 1)
)
theta <- as.vector(x$parameter)
ll_hmm(theta = theta, data = x$data, states = states, sdd = sdd)

}
