% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{plot.ocp}
\alias{plot.ocp}
\title{Plot Object}
\usage{
\method{plot}{ocp}(x, data = NULL, Rmat = NULL,
  graph_changepoints = TRUE, graph_probabilities = TRUE,
  showmaxes = TRUE, showmeans = TRUE, showcps = TRUE,
  showdata = TRUE, showRprobs = TRUE, cplistID = 3,
  main_title = "", trueCPs = NULL, showdataleg = TRUE,
  timepoints = NULL, timeunits = NULL, grey_digits = 4,
  varnames = NULL, ...)
}
\arguments{
\item{x}{the ocp object to plot}

\item{data}{optional input data to plot}

\item{Rmat}{optional input Rmat to plot}

\item{graph_changepoints}{set to TRUE to graph the changepoints}

\item{graph_probabilities}{set TRUE to show R matrix graphed}

\item{showmaxes}{set TRUE to show the maxes in each columns
in the R matrix plot}

\item{showmeans}{set TRUE to show the means on the changepoints
plot}

\item{showcps}{set TRUE to show the the locations of changepoints}

\item{showdata}{set TRUE to show the actual data points}

\item{showRprobs}{set TRUE to show the probabilities in
the R matrix}

\item{cplistID}{method of extracting the changepoints:
either "colmaxes", "threshcps", or "maxCPs" stored in the "changepoints_list"
in the ocpd object}

\item{main_title}{The main title for both plots, e.g. "Eurogames Data"}

\item{trueCPs}{input the true known changepoints for comparison}

\item{showdataleg}{Set true to show legend for the data points, set to false
if there are too many dimensions, legend will be crowded.}

\item{timepoints}{List of timepoints to use as x-axis labels.}

\item{timeunits}{Units to display for the timescale on the plot.}

\item{grey_digits}{The limit of decimal places to keep in the probability
before converting to an index in the grey-scale, controls amount of detail
and darkness of the shading on the plot.}

\item{varnames}{List of variable names to display in the legend.}

\item{...}{(optional) additional arguments, ignored.}
}
\description{
Plot ocpd object, to show the data and the R matrix
 probabilities.
}
\examples{
simdatapts<- c(rnorm(n = 50), rnorm(n=50, 100))
ocpd1<- onlineCPD(simdatapts, getR=TRUE)
plot(ocpd1) # basic plot
plot(ocpd1, data= simdatapts) # plot with the original data
plot(ocpd1, trueCPs = c(1, 51)) # plot with showing the true changepoints
plot(ocpd1, main_title="Example plot", showmaxes = FALSE) # not showing max probabilities
plot(ocpd1, graph_changepoints=FALSE) # not showing the changepoints plot
plot(ocpd1, graph_probabilities=FALSE) # not showing the R matrix
plot(ocpd1, showRprobs=FALSE, showcps= FALSE)#plotting r with maxes but no probabilities,
# and not showing the locations of the found changepoints

}
