% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic-s3.R
\name{print.ocf}
\alias{print.ocf}
\title{Print Method for ocf Objects}
\usage{
\method{print}{ocf}(x, ...)
}
\arguments{
\item{x}{An \code{\link{ocf}} object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Prints an \code{\link{ocf}} object.
}
\description{
Prints an \code{\link{ocf}} object.
}
\examples{
\donttest{
## Load data from orf package.
set.seed(1986)

library(orf)
data(odata)
odata <- odata[1:200, ] # Subset to reduce elapsed time.

y <- as.numeric(odata[, 1])
X <- as.matrix(odata[, -1])

## Fit ocf.
forests <- ocf(y, X)

## Print.
print(forests)}

}
\seealso{
\code{\link{ocf}}
}
\author{
Riccardo Di Francesco
}
