% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xbt.R
\name{read.xbt.edf}
\alias{read.xbt.edf}
\title{Read a Sippican '.edf' format xbt file}
\usage{
read.xbt.edf(
  file,
  longitude = NA,
  latitude = NA,
  debug = getOption("oceDebug"),
  processingLog
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file to
load.}

\item{longitude}{optional signed number indicating the longitude in degrees
East.}

\item{latitude}{optional signed number indicating the latitude in degrees North.}

\item{debug}{a flag that turns on debugging.  The value indicates the depth
within the call stack to which debugging applies.}

\item{processingLog}{if provided, the action item to be stored in the log.  This
parameter is typically only provided for internal calls; the default that it
provides is better for normal calls by a user.}
}
\value{
An \linkS4class{xbt} object.
}
\description{
Read a Sippican '.edf' format xbt file
}
\examples{
library(oce)
xbt <- read.oce(system.file("extdata", "xbt.edf", package="oce"))
summary(xbt)
plot(xbt)

}
\author{
Dan Kelley
}
