% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{predict.tidem}
\alias{predict.tidem}
\title{Predict a Tidal Signal}
\usage{
\method{predict}{tidem}(object, newdata, ...)
}
\arguments{
\item{object}{a \linkS4class{tidem} object.}

\item{newdata}{vector of POSIXt times at which to make the
prediction.  For models created with \code{\link[=tidem]{tidem()}},
the \code{newdata} argument is optional, and if it is not provided, then
the predictions are at the observation times given to
\code{\link[=tidem]{tidem()}}. However, \code{newdata} is required  if \code{\link[=as.tidem]{as.tidem()}}
had been used to create \code{object}.}

\item{\dots}{optional arguments passed on to children.}
}
\value{
A vector of predictions.
}
\description{
This creates a time-series of predicted tides, based on a
tidal model object that was created by \code{\link[=as.tidem]{as.tidem()}} or \code{\link[=tidem]{tidem()}}.
}
\examples{

\dontrun{
library(oce)
# 1. tidal anomaly
data(sealevelTuktoyaktuk)
time <- sealevelTuktoyaktuk[["time"]]
elevation <- sealevelTuktoyaktuk[["elevation"]]
oce.plot.ts(time, elevation, type='l', ylab="Height [m]", ylim=c(-2, 6))
tide <- tidem(sealevelTuktoyaktuk)
lines(time, elevation - predict(tide), col="red")
abline(h=0, col="red")

# 2. prediction at specified times
data(sealevel)
m <- tidem(sealevel)
## Check fit over 2 days (interpolating to finer timescale)
look <- 1:48
time <- sealevel[["time"]]
elevation <- sealevel[["elevation"]]
oce.plot.ts(time[look], elevation[look])
# 360s = 10 minute timescale
t <- seq(from=time[1], to=time[max(look)], by=360)
lines(t, predict(m, newdata=t), col='red')
legend("topright", col=c("black","red"),
legend=c("data","model"),lwd=1)
}

}
\seealso{
Other things related to tides: 
\code{\link{[[,tidem-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{as.tidem}()},
\code{\link{plot,tidem-method}},
\code{\link{summary,tidem-method}},
\code{\link{tidedata}},
\code{\link{tidem-class}},
\code{\link{tidemAstron}()},
\code{\link{tidemVuf}()},
\code{\link{tidem}},
\code{\link{webtide}()}
}
\author{
Dan Kelley
}
\concept{things related to tides}
