% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/o2plscv.R
\name{o2cv}
\alias{o2cv}
\title{Cross validation for O2PLS}
\usage{
o2cv(
  X,
  Y,
  nc,
  nx,
  ny,
  group = NULL,
  nr_folds = 5,
  ncores = 1,
  scale = FALSE,
  center = FALSE
)
}
\arguments{
\item{X}{a Numeric matrix (input)}

\item{Y}{a Numeric matrix (input)}

\item{nc}{Integer. Number of joint PLS components.}

\item{nx}{Integer. Number of orthogonal components in X}

\item{ny}{Integer. Number of orthogonal components in Y}

\item{group}{a vector to indicate the group for Y}

\item{nr_folds}{Integer to indicate the folds for cross validation}

\item{ncores}{Integer. Number of CPUs to use for cross validation}

\item{scale}{boolean values determining if data should be scaled or not}

\item{center}{boolean values determining if data should be centered or not}
}
\value{
a data frame with the Q and RMSE values
}
\description{
Cross validation for O2PLS
}
\examples{
set.seed(123)
X = matrix(rnorm(500),50,10)
Y = matrix(rnorm(500),50,10)
X = scale(X, scale = TRUE)
Y = scale(Y, scale = TRUE)
# group factor could be omitted if you don't have any group 
group <- rep(c("Ctrl","Treat"), each = 25)
cv <- o2cv(X, Y, 1:2, 1:2, 1:2, group=group, nr_folds = 2, ncores=1)
}
\author{
Kai Guo
}
