% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsgexp.R
\name{Neutrosophic Generalized Exponential}
\alias{Neutrosophic Generalized Exponential}
\alias{dnsgexp}
\alias{pnsgexp}
\alias{qnsgexp}
\alias{rnsgexp}
\title{Neutrosophic Generalized Exponential Distribution}
\usage{
dnsgexp(x, nu, delta)

pnsgexp(q, nu, delta, lower.tail = TRUE)

qnsgexp(p, nu, delta)

rnsgexp(n, nu, delta)
}
\arguments{
\item{x}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{nu}{the scale parameter, which must be a positive interval.}

\item{delta}{the shape parameter, which must be a positive interval.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(X \ge x)}; otherwise, \eqn{P(X >x)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}
}
\value{
\code{pnsgexp} gives the distribution function,
 \code{dnsgexp} gives the density,
 \code{qnsgexp} gives the quantile function and
 \code{rnsgexp} generates random variables
 from the neutrosophic generalized exponential distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the neutrosophic generalized exponential
distribution with shape parameter \eqn{\delta_N} and scale parameter
\eqn{\nu_N} or equ.
}
\details{
The neutrosophic generalized exponential distribution with parameters
\eqn{\delta} and \eqn{\nu} has density
\deqn{f_n(x)=\frac{\delta_N}{\nu_N}\left(1-\exp \left\{-\frac{x_N}{\nu_N}\right\}\right)^{\delta_N-1} e^{\left\{-\frac{x_N}{\nu_N}\right\}}}
for \eqn{\delta_N \in (\delta_L, \delta_U)}, the shape parameter
which must be a positive interval, and \eqn{\nu_N \in (\nu_L, \nu_U)}, the
scale parameter which must also be a positive interval, and \eqn{x \ge 0}.
}
\examples{

data(remission)
dnsgexp(x = remission, nu = c(7.9506, 8.0568), delta = c(1.2390, 1.2397))

pnsgexp(q = 20, nu = c(7.9506, 8.0568), delta = c(1.2390, 1.2397))


# Calcluate quantiles
qnsgexp(c(0.25, 0.5, 0.75), nu = c(7.9506, 8.0568), delta = c(1.2390, 1.2397))

# Simulate 10 values
rnsgexp(n = 10, nu = c(7.9506, 8.0568), delta = c(1.2390, 1.2397))

}
\references{
Rao, G. S., Norouzirad, M., and Mazarei . D. (2023). Neutrosophic
   Generalized Exponential Distribution with Application.
   \emph{Neutrosophic Sets and Systems}, 55, 471-485.
}
