% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleEntropy.R
\name{sampleEntropy}
\alias{sampleEntropy}
\alias{sampleEntropyFunction.sampleEntropy}
\alias{nlOrder.sampleEntropy}
\alias{radius.sampleEntropy}
\alias{embeddingDims.sampleEntropy}
\alias{plot.sampleEntropy}
\alias{estimate.sampleEntropy}
\title{Sample Entropy (also known as Kolgomorov-Sinai Entropy)}
\usage{
sampleEntropy(corrDim.object, do.plot = TRUE, ...)

\method{sampleEntropyFunction}{sampleEntropy}(x)

\method{nlOrder}{sampleEntropy}(x)

\method{radius}{sampleEntropy}(x)

\method{embeddingDims}{sampleEntropy}(x)

\method{plot}{sampleEntropy}(x, main = NULL, xlab = NULL,
  ylab = NULL, type = "l", col = NULL, pch = NULL, ylim = NULL,
  log = "x", add.legend = T, ...)

\method{estimate}{sampleEntropy}(x, regression.range = NULL,
  do.plot = TRUE, use.embeddings = NULL, fit.col = NULL,
  fit.lty = 2, fit.lwd = 2, add.legend = T, ...)
}
\arguments{
\item{corrDim.object}{A \emph{corrDim} object from which the Sample Entropy
of the time series characterized by \emph{corrDim} shall be estimated.}

\item{do.plot}{do.plot Logical value. If TRUE (default value), a plot of the 
sample entropy is shown.}

\item{...}{Additional plotting arguments.}

\item{x}{A \emph{sampleEntropy} object.}

\item{main}{A title for the plot.}

\item{xlab}{A title for the x axis.}

\item{ylab}{A title for the y axis.}

\item{type}{Type of plot (see \code{\link[graphics]{plot}}).}

\item{col}{Vector of colors for each of the dimensions of the plot.}

\item{pch}{Vector of symbols for each of the dimensions of the plot}

\item{ylim}{Numeric vector of length 2, giving the y coordinates range..}

\item{log}{A character string which contains "x" if the x axis is to be 
logarithmic, "y" if the y axis is to be logarithmic and "xy" or "yx" if 
both axes are to be logarithmic.}

\item{add.legend}{add a legend to the plot?}

\item{regression.range}{Vector with 2 components denoting the range where the
function will perform linear regression.}

\item{use.embeddings}{A numeric vector specifying which embedding dimensions 
should the \emph{estimate} function use to compute
the sample entropy.}

\item{fit.col}{A vector of colors to plot the regression lines.}

\item{fit.lty}{The type of line to plot the regression lines.}

\item{fit.lwd}{The width of the line for the regression lines.}
}
\value{
A \emph{sampleEntropy} object that contains a list storing the 
sample entropy (\emph{sample.entropy}), the embedding dimensions 
(\emph{embedding.dims}) and radius (\emph{radius}) for which the sample 
entropy has been computed, and the order of the sample entropy 
(\emph{entr.order}). The sample entropy is stored as a matrix in which 
each row contains the computations for a given embedding dimension and 
each column stores the computations for a given radius.

The \emph{sampleEntropyFunction} returns the sample entropy function
\eqn{h_q(m,r)} used for the computations. The sample
entropy function is represented by a matrix. Each row represents a given
embedding dimension whereas that each column representes a different radius.

The \emph{nlOrder} function returns the order of the sample entropy.

The \emph{radius} function returns the radius on which the sample 
entropy function has been evaluated.

The \emph{embeddingDims} function returns the embedding dimensions 
on which the sample entropy function has been evaluated.

The \emph{plot} function shows the graphics for the sample entropy.

The  \emph{estimate} function returns a vector storing the sample 
entropy estimate for each embedding dimension.
}
\description{
The Sample Entropy measures the complexity of a time series. Large values of 
the Sample Entropy indicate high complexity whereas that smaller values 
characterize more regular signals.
}
\details{
The sample entropy is computed using:
\deqn{h_q(m,r) = log(C_q(m,r)/C_{q}(m+1,r))}{hq(m,r) = log(Cq(m,r)/Cq(m+1,r)),}
where \emph{m} is the embedding dimension and \emph{r} is the radius of the 
neighbourhood. When computing the correlation dimensions we use the linear 
regions from the correlation sums in order to do the estimates. Similarly, 
the sample entropy \eqn{h_q(m,r)}{hq(m,r)} should not change for both 
various \emph{m} and \emph{r}.

For each embedding dimension the sample
entropy is estimated by averaging  \deqn{h_q(m,r) = log(C_q(m,r)/C_{q}(m+1,r))}{hq(m,r) = log(Cq(m,r)/Cq(m+1,r))}
over the range specified by \emph{regression range} in the \emph{estimate} 
function.
}
\examples{
\dontrun{
x=henon(n.sample = 15000, n.transient = 100, a = 1.4, b = 0.3, 
        start = c(0.78,0.8165), do.plot = FALSE)$x

cd=corrDim(time.series=x,
           min.embedding.dim=2,max.embedding.dim=9,
           corr.order=2,time.lag=1,
           min.radius=0.05,max.radius=1,
           n.points.radius=100,
           theiler.window=20,
           do.plot=TRUE)

use.col = c("#999999", "#E69F00", "#56B4E9", "#009E73", 
            "#F0E442", "#0072B2", "#D55E00", "#CC79A7")
se=sampleEntropy(cd,do.plot=TRUE,col=use.col,
                 type="l",xlim=c(0.1,1),
                 add.legend=T)
se.est = estimate(se,
                  regression.range = c(0.4,0.6),
                  use.embeddings = 6:9,col=use.col,type="b")
print(se.est)
cat("Expected K2 = ",0.325," Estimated = ",mean(se.est),"\\n")
}
}
\references{
H. Kantz  and T. Schreiber: Nonlinear Time series Analysis 
(Cambridge university press)
}
\author{
Constantino A. Garcia
}
