% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morlini.R
\name{morlini}
\alias{morlini}
\title{Morlini and Zani's (MZ) Measure}
\usage{
morlini(data)
}
\arguments{
\item{data}{A \emph{data.frame} or a \emph{matrix} with cases in rows and variables in colums.}
}
\value{
The function returns a dissimilarity matrix of the size \code{n x n}, where \code{n} is the number of objects in the original dataset in the argument \code{data}.
\cr
}
\description{
A function for calculation of a proximity (dissimilarity) matrix based on the MZ similarity measure.
\cr
}
\details{
The MZ measure was originally introduced by Morlini and Zani (2012) under the name S2. The S2 measure was proposed. It is based on a binary-transformed dataset, so the \bold{morlini} function must first create dummy-coded variables.
The measure uses relative frequencies of categories of binary-coded variables, and it assigns higher weights to infrequent categories.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.morlini <- morlini(data20)

}
\references{
Morlini I., Zani S. (2012). A new class of weighted similarity indices using polytomous variables. Journal of Classification, 29(2), p. 199-226.
}
\seealso{
\code{\link[nomclust]{eskin}},
\code{\link[nomclust]{good1}},
\code{\link[nomclust]{good2}},
\code{\link[nomclust]{good3}},
\code{\link[nomclust]{good4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
