% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-pars.R
\name{set_pars.nlist}
\alias{set_pars.nlist}
\title{Set Parameter Names}
\usage{
\method{set_pars}{nlist}(x, value, ...)
}
\arguments{
\item{x}{An object.}

\item{value}{A character vector of the new parameter names.}

\item{...}{Other arguments passed to methods.}
}
\value{
The modified object.
}
\description{
Sets an object's parameter names.

The assignment version \verb{pars<-()} forwards to \code{set_pars()}.
}
\details{
\code{value} must be a unique character vector of the same length as the
object's parameters.
}
\examples{
nlist <-  nlist(x = 1, y = 3:4)
pars(nlist) <- c("a", "b")
nlist
set_pars(nlist, c("z", "c1"))
}
\seealso{
Other parameters: 
\code{\link[universals]{npars}()},
\code{\link[universals]{pars}()}
}
