% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summary.netmeta.R
\name{print.summary.netmeta}
\alias{print.summary.netmeta}
\title{Print detailed results of network meta-analysis}
\usage{
\method{print}{summary.netmeta}(
  x,
  sortvar,
  common = x$x$common,
  random = x$x$random,
  prediction = x$prediction,
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  all.treatments = x$all.treatments,
  details = TRUE,
  nma = TRUE,
  overall.hetstat = x$overall.hetstat,
  backtransf = x$backtransf,
  nchar.trts = x$nchar.trts,
  nchar.studlab = x$nchar.studlab,
  digits = gs("digits"),
  digits.se = gs("digits.se"),
  digits.pval.Q = max(gs("digits.pval.Q"), 2),
  digits.Q = gs("digits.Q"),
  digits.tau2 = gs("digits.tau2"),
  digits.I2 = gs("digits.I2"),
  big.mark = gs("big.mark"),
  scientific.pval = gs("scientific.pval"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  print.tau2 = gs("print.tau2"),
  print.tau = gs("print.tau"),
  print.Q = gs("print.Q"),
  print.I2 = gs("print.I2"),
  print.I2.ci = gs("print.I2.ci"),
  truncate,
  text.truncate = "*** Output truncated ***",
  details.methods = gs("details"),
  legend = gs("legend"),
  warn.deprecated = gs("warn.deprecated"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{summary.netmeta}.}

\item{sortvar}{An optional vector used to sort individual studies
(must be of same length as \code{x$TE}).}

\item{common}{A logical indicating whether results for the common
effects model should be printed.}

\item{random}{A logical indicating whether results for the random
effects model should be printed.}

\item{prediction}{A logical indicating whether prediction intervals
should be printed.}

\item{reference.group}{Reference treatment.}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa. This argument is
only considered if \code{reference.group} has been specified.}

\item{all.treatments}{A logical or \code{"NULL"}. If \code{TRUE},
matrices with all treatment effects, and confidence limits will
be printed.}

\item{details}{A logical indicating whether further details for
individual studies should be printed.}

\item{nma}{A logical indicating whether summary results of network
meta-analysis should be printed.}

\item{overall.hetstat}{A logical indicating whether to print heterogeneity
measures.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and forest plots. If
\code{backtransf = TRUE}, results for \code{sm = "OR"} are
presented as odds ratios rather than log odds ratios, for
example.}

\item{nchar.trts}{A numeric defining the minimum number of
characters used to create unique treatment names.}

\item{nchar.studlab}{A numeric defining the minimum number of
characters used to create unique study labels.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.se}{Minimal number of significant digits for standard
deviations and standard errors, see \code{print.default}.}

\item{digits.pval.Q}{Minimal number of significant digits for
p-value of heterogeneity tests, see \code{print.default}.}

\item{digits.Q}{Minimal number of significant digits for
heterogeneity statistics, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{digits.I2}{Minimal number of significant digits for I-squared
statistic, see \code{print.default}.}

\item{big.mark}{A character used as thousands separator.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
overall effect should be printed according to JAMA reporting
standards.}

\item{print.tau2}{A logical specifying whether between-study
variance \eqn{\tau^2} should be printed.}

\item{print.tau}{A logical specifying whether \eqn{\tau}, the
square root of the between-study variance \eqn{\tau^2}, should be
printed.}

\item{print.Q}{A logical value indicating whether to print the
results of the test of heterogeneity.}

\item{print.I2}{A logical specifying whether heterogeneity
statistic I\eqn{^2} should be printed.}

\item{print.I2.ci}{A logical specifying whether confidence interval for
heterogeneity statistic I\eqn{^2} should be printed.}

\item{truncate}{An optional vector used to truncate the printout of
results for individual studies (must be a logical vector of
length corresponding to the number of pairwise comparisons
\code{x$TE} or contain numerical values).}

\item{text.truncate}{A character string printed if study results
were truncated from the printout.}

\item{details.methods}{A logical specifying whether details on statistical
methods should be printed.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{\dots}{Additional arguments.}
}
\description{
Print method for objects of class \code{summary.netmeta}.
}
\examples{
data(smokingcessation)

# Transform data from arm-based format to contrast-based format
#
pw1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")

# Conduct random effects network meta-analysis and print detailed
# summary
#
net1 <- netmeta(pw1, common = FALSE)
summary(net1)

\donttest{
data(Senn2013)

# Conduct common effects network meta-analysis
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD", random = FALSE, ref = "plac")
snet2 <- summary(net2)
print(snet2, digits = 3)

# Only show individual study results for multi-arm studies
#
print(snet2, digits = 3, truncate = multiarm)

# Only show first three individual study results
#
print(snet2, digits = 3, truncate = 1:3)

# Only show individual study results for Kim2007 and Willms1999
#
print(snet2, digits = 3, truncate = c("Kim2007", "Willms1999"))

# Only show individual study results for studies starting with the
# letter "W"
#
print(snet2, ref = "plac", digits = 3,
  truncate = substring(studlab, 1, 1) == "W")

# Conduct random effects network meta-analysis
#
net3 <- netmeta(TE, seTE, treat1, treat2, studlab,
  data = Senn2013, sm = "MD", common = FALSE, ref = "plac")
print(summary(net3), digits = 3)
}

}
\seealso{
\code{\link{netmeta}}, \code{\link{summary.netmeta}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{print}
