% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterTSPInstances.R
\name{filterTSPInstances}
\alias{filterTSPInstances}
\title{Filter TSPlib instances according to its specifications.}
\usage{
filterTSPInstances(directory = NULL, expr, paths.only = FALSE)
}
\arguments{
\item{directory}{[\code{character(1)}]\cr
Readable directory path.}

\item{expr}{[\code{expression}]\cr
Expression wrapped with the \code{\link{.}} function.}

\item{paths.only}{[\code{logical(1)}]\cr
Should only the full file names of the instances be returned?
Default is \code{FALSE}.}
}
\value{
[\code{data.frame}]
}
\description{
Given a directory, this function reads the specifications
of each TSPlib instance in that directory and returns a subset.
}
\examples{
\dontrun{
# Get a data frame of instances and its properties for all instances
# with more than 4000 nodes
filterTSPInstances("path/to/instances", dimension > 4000)

# Now get only the full file names of all instances with edge weight type
# EUC_2D or CEIL_2D (see tsplib documentation for details)
filterTSPInstances("path/to/instances",
  expr = edge_weight_type \%in\% c("EUC_2D", "CEIL_2D"),
  paths.only = TRUE
)
}

}
\seealso{
\code{\link{getTSPInstancesOverview}}
}

