% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNodeWeights.R
\name{addNodeWeights}
\alias{addNodeWeights}
\title{Add node weights.}
\usage{
addNodeWeights(x, weights = NULL)
}
\arguments{
\item{x}{[\code{Network}]\cr
Network.}

\item{weights}{[\code{numeric(1)}]\cr
Numeric vector of weights.}
}
\description{
This function adds node weights to an edge-weighted graph. This is of interest
in the study of weighted TSP, where the distance between two nodes is not based
on the actual distance but additionally is influenced by the weight of the starting
node or all nodes prior in the permutation. This is indeed of practical interest.
E.g. consider a garbage collecting vehicle which requires the more gas per mile
the heavier its load.
}
\seealso{
\code{\link{generateRandomNetwork}}, \code{\link{generateClusteredNetwork}},
\code{\link{generateGridNetwork}}
}
