% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipsByProduct.R
\name{zipsByProduct}
\alias{zipsByProduct}
\title{Get files from NEON API to feed the stackByTable() function}
\usage{
zipsByProduct(
  dpID,
  site = "all",
  startdate = NA,
  enddate = NA,
  package = "basic",
  avg = "all",
  check.size = TRUE,
  savepath = NA,
  load = F,
  token = NA
)
}
\arguments{
\item{dpID}{The identifier of the NEON data product to pull, in the form DPL.PRNUM.REV, e.g. DP1.10023.001}

\item{site}{Either the string 'all', meaning all available sites, or a character vector of 4-letter NEON site codes, e.g. c('ONAQ','RMNP'). Defaults to all.}

\item{startdate}{Either NA, meaning all available dates, or a character vector in the form YYYY-MM, e.g. 2017-01. Defaults to NA.}

\item{enddate}{Either NA, meaning all available dates, or a character vector in the form YYYY-MM, e.g. 2017-01. Defaults to NA.}

\item{package}{Either 'basic' or 'expanded', indicating which data package to download. Defaults to basic.}

\item{avg}{Either the string 'all', or the averaging interval to download, in minutes. Only applicable to sensor (IS) data. Defaults to 'all'.}

\item{check.size}{T or F, should the user approve the total file size before downloading? Defaults to T. When working in batch mode, or other non-interactive workflow, use check.size=F.}

\item{savepath}{The location to save the output files to}

\item{load}{T or F, are files saved locally or loaded directly? Used silently with loadByProduct(), do not set manually.}

\item{token}{User specific API token (generated within neon.datascience user accounts). Optional.}
}
\value{
A folder in the working directory (or in savepath, if specified), containing all zip files meeting query criteria.
}
\description{
Pull files from the NEON API, by data product, in a structure that will allow them to be stacked by the stackByTable() function
}
\details{
All available data meeting the query criteria will be downloaded. Most data products are collected at only a subset of sites, and dates of collection vary. Consult the NEON data portal for sampling details.
Dates are specified only to the month because NEON data are provided in monthly packages. Any month included in the search criteria will be included in the download. Start and end date are inclusive.
}
\examples{
\dontrun{
# To download plant foliar properties data from all sites, expanded data package:
zipsByProduct(dpID="DP1.10026.001", site="all", package="expanded")
}
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Claire Lunch \email{clunch@battelleecology.org}
}
