\name{summary.Sncf}
\alias{summary.Sncf}
\title{Summarizing nonparametric spatial correlation-functions}
\description{
  `Summary' method for class "Sncf".  
}

\usage{
    \method{summary}{Sncf}(object, ...)
}
\arguments{
  \item{object}{an object of class "Sncf", usually, as a result
  of a call to \code{\link{Sncf}} (or \code{\link{Sncf.srf}}).}
  \item{\dots}{other arguments}
  }

\details{
}

\value{
A list summarizing the nonparametric (cross-)covariance
function is returned.

\item{Regional.synch}{the regional mean (cross-)correlation.} 
\item{Squantile}{the quantile distribution from the 
  resampling for the regional correlation.}

\item{estimates}{a vector of benchmark statistics:}
\item{$x}{is the lowest value at which the function is = 0. 
  If correlation is initially negative, the distance 
  calculated appears as a negative measure.}
\item{$e}{is the lowest value at which the 
  function is <= 1/e.}
\item{$y}{is the extrapolated value at x=0.} 
\item{$cbar}{is the shortest distance at which 
  function is = regional mean correlation.}
  
\item{quantiles}{A matrix summarizing the quantiles in the 
  bootstrap (or null) distributions of the benchmark statistics.}
} 

\seealso{\code{\link{Sncf}} 
\code{\link{plot.Sncf}} 
}

\keyword{smooth}
\keyword{regression}
