% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{stream}
\alias{stream}
\title{Open Stream}
\usage{
stream(dial = NULL, listen = NULL, textframes = FALSE, tls = NULL)
}
\arguments{
\item{dial}{a URL to dial, specifying the transport and address as a
character string e.g. 'ipc:///tmp/anyvalue' or 'tcp://127.0.0.1:5555' (not
all transports are supported).}

\item{listen}{a URL to listen at, specifying the transport and address as a
character string e.g. 'ipc:///tmp/anyvalue' or 'tcp://127.0.0.1:5555' (not
all transports are supported).}

\item{textframes}{[default FALSE] applicable to the websocket transport
only, enables sending and receiving of TEXT frames (ignored otherwise).}

\item{tls}{(optional) applicable to secure websockets only, a client or
server TLS configuration object created by \code{\link[=tls_config]{tls_config()}}. If missing or
NULL, certificates are not validated.}
}
\value{
A Stream (object of class 'nanoStream' and 'nano').
}
\description{
Open a Stream by either dialing (establishing an outgoing connection) or
listening (accepting an incoming connection) at an address. This is a
low-level interface intended for communicating with non-NNG endpoints.
}
\details{
A Stream is used for raw byte stream connections. Byte streams are reliable
in that data will not be delivered out of order, or with portions missing.

Can be used to dial a (secure) websocket address starting 'ws://' or
'wss://'. It is often the case that \code{textframes} needs to be set to \code{TRUE}.

Specify only one of \code{dial} or \code{listen}. If both are specified, \code{listen} will
be ignored.

Closing a stream renders it invalid and attempting to perform additional
operations on it will error.
}
\examples{
# Will succeed only if there is an open connection at the address:
s <- tryCatch(stream(dial = "tcp://127.0.0.1:5555"), error = identity)
s
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Run in interactive sessions only as connection is not always available:
s <- tryCatch(
  stream(dial = "wss://echo.websocket.events/", textframes = TRUE),
  error = identity
)
s
if (is_nano(s)) recv(s)
if (is_nano(s)) send(s, "hello")
if (is_nano(s)) recv(s)
if (is_nano(s)) close(s)
\dontshow{\}) # examplesIf}
}
