% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plot_graph}
\alias{plot_graph}
\title{Plot Graph (Network)}
\usage{
plot_graph(
  reshaped_results,
  ontology_id_colname = "ontology_id",
  ontology_element_colname = "element_id_in_ontology",
  shared_elements_min_threshold = 0,
  p_value_type_colname = "eFDR",
  p_value_max_threshold = 0.05
)
}
\arguments{
\item{reshaped_results}{Character, the input \code{data.table} containing the
reshaped results.}

\item{ontology_id_colname}{Character, the name of the column in the reshaped
results that contains ontology identifiers or names. Default value is
'ontology_id'.}

\item{ontology_element_colname}{Character, the name of the column in the
reshaped results that contains element identifiers within the ontology.
Default value is 'element_id_in_ontology'.}

\item{shared_elements_min_threshold}{Numeric, threshold specifying the
minimum number of shared elements required between two ontologies to
consider them connected by an edge on the graph. Default value is 0.}

\item{p_value_type_colname}{Character, the name of the column in the reshaped
results that contains the type of \emph{p}-values associated with the ontology
elements. Default value is 'eFDR'.}

\item{p_value_max_threshold}{Numeric, a threshold value for filtering
rows in the reshaped results based on the
\emph{p}-values. Rows with \emph{p}-values greater
than this threshold will be filtered out.
Default value is 0.05.}
}
\value{
Returns a graph plot.
}
\description{
Plots graph representation of enrichment results.
}
\details{
This function generates a graph (network) visualization of the
enriched ontology entries. On the plot each node represents an ontology
entry below a given \emph{p}-value threshold, and is coloured based on its
significance level. A connection (edge) is drawn between two nodes if they
share at least one common element (gene) belonging to the target set -- in
the case of ORA results -- or all analysed elements -- in the case of GSEA
results.
}
\examples{
library(mulea)

# loading and filtering the example ontology from a GMT file
tf_gmt <- read_gmt(file = system.file(package="mulea", "extdata", 
    "Transcription_factor_RegulonDB_Escherichia_coli_GeneSymbol.gmt"))
tf_gmt_filtered <- filter_ontology(gmt = tf_gmt, min_nr_of_elements = 3, 
    max_nr_of_elements = 400)

# loading the example data
sign_genes <- readLines(system.file(package = "mulea", "extdata", 
    "target_set.txt"))
background_genes <- readLines(system.file(
    package="mulea", "extdata", "background_set.txt"))

# creating the ORA model
ora_model <- ora(gmt = tf_gmt_filtered,
    # the test set variable
    element_names = sign_genes, 
    # the background set variable
    background_element_names = background_genes, 
    # the p-value adjustment method
    p_value_adjustment_method = "eFDR", 
    # the number of permutations
    number_of_permutations = 10000,
    # the number of processor threads to use
    nthreads = 2)
# running the ORA
ora_results <- run_test(ora_model)

# reshaping results for visualisation
ora_reshaped_results <- reshape_results(model = ora_model,
    model_results = ora_results,
    # choosing which column to use for the indication of significance
    p_value_type_colname = "eFDR")

# Plot graph
plot_graph(reshaped_results = ora_reshaped_results,
    # the column containing the names we wish to plot
    ontology_id_colname = "ontology_id",
    # upper threshold for the value indicating the significance
    p_value_max_threshold = 0.05,
    # column that indicates the significance values
    p_value_type_colname = "eFDR")
}
\seealso{
\code{\link{reshape_results}}
}
