% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{ncompsearch}
\alias{ncompsearch}
\alias{plot.ncompsearch}
\alias{print.ncompsearch}
\title{Search for Number of Components}
\usage{
ncompsearch(X, Y = NULL, Z = NULL, comps = 1:3, lambdaX = NULL,
  lambdaY = NULL, eta = 1, type = "lasso", inX = NULL, inY = NULL,
  muX = 0, muY = 0, nfold = 5, regpara = FALSE, maxrep = 3,
  method = c("BIC", "CV")[1])

\method{print}{ncompsearch}(x, ...)

\method{plot}{ncompsearch}(x, ...)
}
\arguments{
\item{X}{a (list of) matrix, explanatory variable(s) which is required.}

\item{Y}{a (list of) matrix, objective variable(s). This is optional. If no input for Y, then the PCA method is implemented.}

\item{Z}{a vector, response variable(s). This is optional. The length is the number of subjects. If no input for Z, then the unsupervised PLS/PCA is implemented.}

\item{comps}{numeric vector for the candidates of the numbers of components to be selected.}

\item{lambdaX}{numeric vector of regularized parameters for X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{eta}{numeric scalar, the parameter indexing the penalty family. This version has only the choice 1.}

\item{type}{a character, the penalty family. This version has only the choice "lasso".}

\item{inX}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inY}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{muX}{a numeric scalar for the weight of X for the supervised. 0<=muX<=1.}

\item{muY}{a numeric scalar for the weight of Y for the supervised. 0<=muY<=1.}

\item{nfold}{number of folds - default is 5.}

\item{regpara}{logical, If TRUE, the regularized parameters search is also conducted simultaneously.}

\item{maxrep}{numeric scalar for the number of iteration.}

\item{method}{a character, the evaluation method, "CV" for cross-validation based on matrix element-wise error, and "BIC" for Bayesian information criteria. The default is the BIC.}

\item{x}{an object of class "\code{ncompsearch}", usually, a result of a call to \code{ncompsearch}}

\item{...}{further arguments passed to or from other methods.}
}
\value{
\item{comps}{numbers of components}

\item{mincriterion}{minimum criterion value}

\item{criterions}{criterion values}

\item{optncomp}{optimal number of components with the minimum criteria value}
}
\description{
Determination for the number of components based on cross-validated method or the Bayesian information criterion (BIC)
}
\details{
This function provide an implementation of a search the optimal number of components.
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### number of components search #####
ncomp1 = ncompsearch(X, Y, comps = c(1, 5, 10*(1:5)), nfold=5)
plot(ncomp1)

}

