% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{templates}
\alias{templates}
\alias{make_template}
\alias{read_template}
\alias{write_template}
\alias{template_exists}
\alias{sync_template}
\alias{template_current}
\title{Handle message templates (.pot files)}
\usage{
make_template(charset = "UTF-8", pkg = ".", domain = "R")

read_template(pkg = ".", domain = "R")

write_template(template, pkg = ".", verbose = getOption("verbose"))

template_exists(pkg = ".", domain = "R")

sync_template(charset = "UTF-8", pkg = ".", domain = "R",
  verbose = getOption("verbose"))

template_current(template, pkg = ".", domain = "R")
}
\arguments{
\item{charset}{A character string specifying the character set of the translation template file.}

\item{pkg}{The directory of an R package to extract diagnostic messages from. Path is passed to \code{\link[devtools]{as.package}}.}

\item{domain}{A character string specifying the \dQuote{domain} of the messages. Either \dQuote{R} (the default) or \dQuote{C}. This is case insensitive.}

\item{template}{An object of class \dQuote{po} containing a message translation template.}

\item{verbose}{A logical. Should the function be chatty?}
}
\value{
\code{make_template} and \code{read_template} reutrn an R6 object of class \dQuote{po}. \code{write_template} returns the path to the file, invisibly.
}
\description{
Read, write, and generate .pot diagnostic message templates
}
\details{
\code{read_template} and \code{write_template} provide basic input and output functionality for translation template (.pot) files. If called from with an R package directory, the locations of these fies are identified automatically.

\code{make_template} generates a new template in memory, without writing it to disk. \code{sync_template} makes a new template and writes it to disk or, if a template file already exists, overwrites it.

\code{sync_template()} updates the template file. \code{\link{sync_translations}} further updates translation files against that template.
}
\examples{
pkg <- dummy_pkg()

# check for existing template
try(template_exists(pkg = pkg))

# generate an in-memory template
pot <- make_template(pkg = pkg)
write_template(pot, pkg = pkg)
  
}
\seealso{
\code{\link{get_messages}} to read messages into memory without creating a template file, \code{\link{use_localization}} to setup a package for localization (including generation of a template file)
}
\author{
Thomas J. Leeper
}
